/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.FujifilmMakernoteDirectory;

public class FujifilmMakernoteDescriptor
extends TagDescriptor<FujifilmMakernoteDirectory> {
    public FujifilmMakernoteDescriptor(@NotNull FujifilmMakernoteDirectory fujifilmMakernoteDirectory) {
        super(fujifilmMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 4097: {
                return this.getSharpnessDescription();
            }
            case 4098: {
                return this.getWhiteBalanceDescription();
            }
            case 4099: {
                return this.getColorDescription();
            }
            case 4100: {
                return this.getToneDescription();
            }
            case 4112: {
                return this.getFlashModeDescription();
            }
            case 4113: {
                return this.getFlashStrengthDescription();
            }
            case 4128: {
                return this.getMacroDescription();
            }
            case 4129: {
                return this.getFocusModeDescription();
            }
            case 4144: {
                return this.getSlowSyncDescription();
            }
            case 4145: {
                return this.getPictureModeDescription();
            }
            case 4352: {
                return this.getContinuousTakingOrAutoBrackettingDescription();
            }
            case 4864: {
                return this.getBlurWarningDescription();
            }
            case 4865: {
                return this.getFocusWarningDescription();
            }
            case 4866: {
                return this.getAutoExposureWarningDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4097);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Softest";
            }
            case 2: {
                return "Soft";
            }
            case 3: {
                return "Normal";
            }
            case 4: {
                return "Hard";
            }
            case 5: {
                return "Hardest";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4098);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 256: {
                return "Daylight";
            }
            case 512: {
                return "Cloudy";
            }
            case 768: {
                return "DaylightColor-fluorescence";
            }
            case 769: {
                return "DaywhiteColor-fluorescence";
            }
            case 770: {
                return "White-fluorescence";
            }
            case 1024: {
                return "Incandescence";
            }
            case 3840: {
                return "Custom white balance";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getColorDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4099);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High (HARD)";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getToneDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4100);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High (HARD)";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4112);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Off";
            }
            case 3: {
                return "Red-eye reduction";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashStrengthDescription() {
        Rational rational = ((FujifilmMakernoteDirectory)this._directory).getRational(4113);
        if (rational == null) {
            return null;
        }
        return rational.toSimpleString(false) + " EV (Apex)";
    }

    @Nullable
    public String getMacroDescription() {
        return this.getOnOffDescription(4128);
    }

    @Nullable
    public String getFocusModeDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4129);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto focus";
            }
            case 1: {
                return "Manual focus";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getSlowSyncDescription() {
        return this.getOnOffDescription(4144);
    }

    @Nullable
    public String getPictureModeDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4145);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Portrait scene";
            }
            case 2: {
                return "Landscape scene";
            }
            case 4: {
                return "Sports scene";
            }
            case 5: {
                return "Night scene";
            }
            case 6: {
                return "Program AE";
            }
            case 256: {
                return "Aperture priority AE";
            }
            case 512: {
                return "Shutter priority AE";
            }
            case 768: {
                return "Manual exposure";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContinuousTakingOrAutoBrackettingDescription() {
        return this.getOnOffDescription(4352);
    }

    @Nullable
    public String getBlurWarningDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4864);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "No blur warning";
            }
            case 1: {
                return "Blur warning";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFocusWarningDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4865);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto focus good";
            }
            case 1: {
                return "Out of focus";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAutoExposureWarningDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4866);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "AE good";
            }
            case 1: {
                return "Over exposed (>1/1000s @ F11)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    private String getOnOffDescription(int n) {
        Integer n2 = ((FujifilmMakernoteDirectory)this._directory).getInteger(n);
        if (n2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + n2 + ")";
    }
}

