/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.Clock;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public class DoubleBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Object notEmptyLock = new Object();
    private final Queue<E> priorityQueue = new ConcurrentLinkedQueue();
    private final Queue<E> defaultQueue = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        this.defaultQueue.offer(e);
        Object object = this.notEmptyLock;
        synchronized (object) {
            this.notEmptyLock.notify();
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        this.put(e);
        return true;
    }

    @Override
    public int size() {
        return this.priorityQueue.size() + this.defaultQueue.size();
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E e = this.tryPoll();
        if (e != null) {
            return e;
        }
        long timeLeft = unit.toMillis(timeout);
        while (e == null && timeLeft > 0L) {
            long start = Clock.currentTimeMillis();
            Object object = this.notEmptyLock;
            synchronized (object) {
                this.notEmptyLock.wait(100L);
            }
            e = this.tryPoll();
            long now = Clock.currentTimeMillis();
            timeLeft -= now - start;
            start = now;
        }
        return e;
    }

    E tryPoll() {
        E e = this.priorityQueue.poll();
        if (e == null) {
            e = this.defaultQueue.poll();
        }
        return e;
    }

    @Override
    public E poll() {
        return this.tryPoll();
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        return this.defaultQueue.offer(e);
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }
}

