/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.IOException;
import java.util.ArrayList;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPage;

public class OggPacketWriter {
    private boolean closed = false;
    private boolean doneFirstPacket = false;
    private OggFile file;
    private int sid;
    private int sequenceNumber;
    private long currentGranulePosition = 0L;
    private ArrayList<OggPage> buffer = new ArrayList();

    protected OggPacketWriter(OggFile parentFile, int sid) {
        this.file = parentFile;
        this.sid = sid;
        this.sequenceNumber = 0;
    }

    public void setGranulePosition(long position) {
        this.currentGranulePosition = position;
        for (OggPage p : this.buffer) {
            p.setGranulePosition(position);
        }
    }

    public long getCurrentGranulePosition() {
        return this.currentGranulePosition;
    }

    public int getSid() {
        return this.sid;
    }

    private OggPage getCurrentPage(boolean forceNew) {
        if (this.buffer.size() == 0 || forceNew) {
            OggPage page = new OggPage(this.sid, this.sequenceNumber++);
            if (this.currentGranulePosition > 0L) {
                page.setGranulePosition(this.currentGranulePosition);
            }
            this.buffer.add(page);
            return page;
        }
        return this.buffer.get(this.buffer.size() - 1);
    }

    public void bufferPacket(OggPacket packet) {
        int size;
        if (this.closed) {
            throw new IllegalStateException("Can't buffer packets on a closed stream!");
        }
        if (!this.doneFirstPacket) {
            packet.setIsBOS();
            this.doneFirstPacket = true;
        }
        boolean emptyPacket = (size = packet.getData().length) == 0;
        OggPage page = this.getCurrentPage(false);
        int pos = 0;
        while (pos < size || emptyPacket) {
            if ((pos = page.addPacket(packet, pos)) < size) {
                page = this.getCurrentPage(true);
                page.setIsContinuation();
            }
            emptyPacket = false;
        }
        packet.setParent(page);
    }

    public void bufferPacket(OggPacket packet, boolean flush) throws IOException {
        this.bufferPacket(packet);
        if (flush) {
            this.flush();
        }
    }

    public int getSizePendingFlush() {
        int size = 0;
        for (OggPage p : this.buffer) {
            size += p.getDataSize();
        }
        return size;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Can't flush packets on a closed stream!");
        }
        OggPage[] pages = this.buffer.toArray(new OggPage[this.buffer.size()]);
        this.file.writePages(pages);
        this.buffer.clear();
    }

    public void close() throws IOException {
        if (this.buffer.size() > 0) {
            this.buffer.get(this.buffer.size() - 1).setIsEOS();
        } else {
            OggPacket p = new OggPacket(new byte[0]);
            p.setIsEOS();
            this.bufferPacket(p);
        }
        this.flush();
        this.closed = true;
    }
}

