/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public final class ConfigCheck
implements IdentifiedDataSerializable {
    private String groupName;
    private String groupPassword;
    private String joinerType;
    private boolean partitionGroupEnabled;
    private PartitionGroupConfig.MemberGroupType memberGroupType;

    public boolean isCompatible(ConfigCheck other) {
        if (!this.groupName.equals(other.groupName)) {
            return false;
        }
        if (!this.groupPassword.equals(other.groupPassword)) {
            throw new HazelcastException("Incompatible group password!");
        }
        if (!this.joinerType.equals(other.joinerType)) {
            throw new HazelcastException("Incompatible joiners! " + this.joinerType + " -vs- " + other.joinerType);
        }
        if (!this.partitionGroupEnabled && other.partitionGroupEnabled || this.partitionGroupEnabled && !other.partitionGroupEnabled) {
            throw new HazelcastException("Incompatible partition groups! this: " + (this.partitionGroupEnabled ? "enabled" : "disabled") + " / " + (Object)((Object)this.memberGroupType) + ", other: " + (other.partitionGroupEnabled ? "enabled" : "disabled") + " / " + (Object)((Object)other.memberGroupType));
        }
        if (this.partitionGroupEnabled && this.memberGroupType != other.memberGroupType) {
            throw new HazelcastException("Incompatible partition groups! this: " + (Object)((Object)this.memberGroupType) + ", other: " + (Object)((Object)other.memberGroupType));
        }
        return true;
    }

    public ConfigCheck setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public ConfigCheck setGroupPassword(String groupPassword) {
        this.groupPassword = groupPassword;
        return this;
    }

    public ConfigCheck setJoinerType(String joinerType) {
        this.joinerType = joinerType;
        return this;
    }

    public ConfigCheck setPartitionGroupEnabled(boolean partitionGroupEnabled) {
        this.partitionGroupEnabled = partitionGroupEnabled;
        return this;
    }

    public ConfigCheck setMemberGroupType(PartitionGroupConfig.MemberGroupType memberGroupType) {
        this.memberGroupType = memberGroupType;
        return this;
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 4;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.groupName);
        out.writeUTF(this.groupPassword);
        out.writeUTF(this.joinerType);
        out.writeBoolean(this.partitionGroupEnabled);
        if (this.partitionGroupEnabled) {
            out.writeUTF(this.memberGroupType.toString());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.groupName = in.readUTF();
        this.groupPassword = in.readUTF();
        this.joinerType = in.readUTF();
        this.partitionGroupEnabled = in.readBoolean();
        if (this.partitionGroupEnabled) {
            String s = in.readUTF();
            try {
                this.memberGroupType = PartitionGroupConfig.MemberGroupType.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

