/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionAddAllBackupOperation;
import com.hazelcast.collection.CollectionBackupAwareOperation;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CollectionAddAllOperation
extends CollectionBackupAwareOperation {
    protected List<Data> valueList;
    protected transient Map<Long, Data> valueMap;

    public CollectionAddAllOperation() {
    }

    public CollectionAddAllOperation(String name, List<Data> valueList) {
        super(name);
        this.valueList = valueList;
    }

    @Override
    public boolean shouldBackup() {
        return this.valueMap != null && !this.valueMap.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CollectionAddAllBackupOperation(this.name, this.valueMap);
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_ADD_ALL;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        if (!this.hasEnoughCapacity(this.valueList.size())) {
            this.response = false;
            return;
        }
        this.valueMap = this.getOrCreateContainer().addAll(this.valueList);
        this.response = !this.valueMap.isEmpty();
    }

    @Override
    public void afterRun() throws Exception {
        if (this.valueMap == null) {
            return;
        }
        for (Data value : this.valueMap.values()) {
            this.publishEvent(ItemEventType.ADDED, value);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.valueList.size());
        for (Data value : this.valueList) {
            value.writeData(out);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.valueList = new ArrayList<Data>(size);
        for (int i = 0; i < size; ++i) {
            Data value = new Data();
            value.readData(in);
            this.valueList.add(value);
        }
    }
}

