/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.osgi.OSGiPlugin;
import com.openexchange.osgi.data.ModuleDatabase;
import com.openexchange.osgi.data.ProjectDatabase;
import com.openexchange.osgi.tasks.ClasspathPrinter;
import com.openexchange.osgi.worker.AwaitExtension;
import com.openexchange.osgi.worker.AwaitExtensionParameters;
import com.openexchange.osgi.worker.JdkWorker;
import com.openexchange.osgi.worker.ProjectDependenciesResolver;
import com.openexchange.osgi.worker.ProjectWorker;
import com.openexchange.osgi.worker.ResolveDependenciesWorker;
import com.openexchange.osgi.worker.WorkerParameters;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/openexchange/osgi/OSGiPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "logger", "Lorg/gradle/api/logging/Logger;", "apply", "", "project", "Companion", "osgi"})
public final class OSGiPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkerExecutor workerExecutor;
    private Logger logger;
    @NotNull
    public static final String PLUGIN_NAME = "OSGi-Plugin";
    public static ModuleDatabase moduleDatabase;
    public static ProjectDatabase projectDatabase;
    public static ConcurrentMap<String, Project> projectsPool;

    @Inject
    public OSGiPlugin(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }

    public void apply(@NotNull Project project) {
        Project subProject;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Logger logger = project.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
        this.logger = logger;
        Logger logger2 = this.logger;
        if (logger2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            logger2 = null;
        }
        logger2.info("{}: Found OSGi-Root-Project: {}", (Object)PLUGIN_NAME, (Object)project.getName());
        Logger logger3 = this.logger;
        if (logger3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            logger3 = null;
        }
        Companion.setModuleDatabase(new ModuleDatabase(logger3));
        Logger logger4 = this.logger;
        if (logger4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            logger4 = null;
        }
        Companion.setProjectDatabase(new ProjectDatabase(logger4));
        Companion.setProjectsPool(new ConcurrentHashMap());
        WorkQueue workQueue = this.workerExecutor.noIsolation();
        Set set = project.getSubprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"project.subprojects");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            subProject = (Project)element$iv;
            boolean bl = false;
            subProject.getPlugins();
            ((Map)Companion.getProjectsPool()).put(subProject.getName(), subProject);
            workQueue.submit(AwaitExtension.class, arg_0 -> OSGiPlugin.apply$lambda$1$lambda$0((Function1)new Function1<AwaitExtensionParameters, Unit>(subProject){
                final /* synthetic */ Project $subProject;
                {
                    this.$subProject = $subProject;
                    super(1);
                }

                public final void invoke(AwaitExtensionParameters params) {
                    params.getProjectName().set((Object)this.$subProject.getName());
                    params.getPluginId().set((Object)"com.openexchange.build.project-type-scanner");
                    params.getExtensionName().set((Object)"projectType");
                }
            }, arg_0));
        }
        workQueue.await();
        Set set2 = project.getSubprojects();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"project.subprojects");
        $this$forEach$iv = set2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            subProject = (Project)element$iv;
            boolean bl = false;
            Logger logger5 = this.logger;
            if (logger5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                logger5 = null;
            }
            Object[] objectArray = new Object[]{PLUGIN_NAME, ProjectWorker.class.getName(), subProject.getName()};
            logger5.debug("{}: Submitting '{}' for project '{}'", objectArray);
            subProject.getPlugins().apply(LifecycleBasePlugin.class);
            workQueue.submit(ProjectWorker.class, arg_0 -> OSGiPlugin.apply$lambda$3$lambda$2((Function1)new Function1<WorkerParameters, Unit>(subProject){
                final /* synthetic */ Project $subProject;
                {
                    this.$subProject = $subProject;
                    super(1);
                }

                public final void invoke(WorkerParameters param) {
                    param.getProjectName().set((Object)this.$subProject.getName());
                }
            }, arg_0));
        }
        workQueue.submit(JdkWorker.class, arg_0 -> OSGiPlugin.apply$lambda$4(apply.3.INSTANCE, arg_0));
        workQueue.await();
        Companion.getModuleDatabase().computeBinaryDependencies();
        Iterator iterator = CollectionsKt.iterator(Companion.getModuleDatabase().modulesIterator());
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            workQueue.submit(ResolveDependenciesWorker.class, arg_0 -> OSGiPlugin.apply$lambda$5((Function1)new Function1<WorkerParameters, Unit>(key){
                final /* synthetic */ String $key;
                {
                    this.$key = $key;
                    super(1);
                }

                public final void invoke(WorkerParameters it) {
                    it.getProjectName().set((Object)this.$key);
                }
            }, arg_0));
        }
        workQueue.await();
        iterator = CollectionsKt.iterator(Companion.getProjectDatabase().projectsIterator());
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            workQueue.submit(ProjectDependenciesResolver.class, arg_0 -> OSGiPlugin.apply$lambda$6((Function1)new Function1<WorkerParameters, Unit>(key){
                final /* synthetic */ String $key;
                {
                    this.$key = $key;
                    super(1);
                }

                public final void invoke(WorkerParameters it) {
                    it.getProjectName().set((Object)this.$key);
                }
            }, arg_0));
        }
        workQueue.await();
        Companion.getModuleDatabase().clear();
        Companion.getProjectDatabase().clear();
        Companion.getProjectsPool().clear();
    }

    private static final void apply$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00132\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lcom/openexchange/osgi/OSGiPlugin$Companion;", "", "()V", "PLUGIN_NAME", "", "moduleDatabase", "Lcom/openexchange/osgi/data/ModuleDatabase;", "getModuleDatabase", "()Lcom/openexchange/osgi/data/ModuleDatabase;", "setModuleDatabase", "(Lcom/openexchange/osgi/data/ModuleDatabase;)V", "projectDatabase", "Lcom/openexchange/osgi/data/ProjectDatabase;", "getProjectDatabase", "()Lcom/openexchange/osgi/data/ProjectDatabase;", "setProjectDatabase", "(Lcom/openexchange/osgi/data/ProjectDatabase;)V", "projectsPool", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/gradle/api/Project;", "getProjectsPool", "()Ljava/util/concurrent/ConcurrentMap;", "setProjectsPool", "(Ljava/util/concurrent/ConcurrentMap;)V", "registerTasks", "", "project", "classpath", "", "Lorg/gradle/api/file/FileCollection;", "osgi"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleDatabase getModuleDatabase() {
            ModuleDatabase moduleDatabase = OSGiPlugin.moduleDatabase;
            if (moduleDatabase != null) {
                return moduleDatabase;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"moduleDatabase");
            return null;
        }

        public final void setModuleDatabase(@NotNull ModuleDatabase moduleDatabase) {
            Intrinsics.checkNotNullParameter((Object)moduleDatabase, (String)"<set-?>");
            OSGiPlugin.moduleDatabase = moduleDatabase;
        }

        @NotNull
        public final ProjectDatabase getProjectDatabase() {
            ProjectDatabase projectDatabase = OSGiPlugin.projectDatabase;
            if (projectDatabase != null) {
                return projectDatabase;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectDatabase");
            return null;
        }

        public final void setProjectDatabase(@NotNull ProjectDatabase projectDatabase) {
            Intrinsics.checkNotNullParameter((Object)projectDatabase, (String)"<set-?>");
            OSGiPlugin.projectDatabase = projectDatabase;
        }

        @NotNull
        public final ConcurrentMap<String, Project> getProjectsPool() {
            ConcurrentMap<String, Project> concurrentMap = projectsPool;
            if (concurrentMap != null) {
                return concurrentMap;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"projectsPool");
            return null;
        }

        public final void setProjectsPool(@NotNull ConcurrentMap<String, Project> concurrentMap) {
            Intrinsics.checkNotNullParameter(concurrentMap, (String)"<set-?>");
            projectsPool = concurrentMap;
        }

        public final void registerTasks(@NotNull Project project, @NotNull Map<String, ? extends FileCollection> classpath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
            Map<String, ? extends FileCollection> $this$forEach$iv = classpath;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ? extends FileCollection>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, ? extends FileCollection> element$iv;
                Map.Entry<String, ? extends FileCollection> entry = element$iv = iterator.next();
                boolean bl = false;
                String name = entry.getKey();
                FileCollection path = entry.getValue();
                project.getTasks().register("print" + StringsKt.capitalize((String)name), ClasspathPrinter.class, arg_0 -> Companion.registerTasks$lambda$1$lambda$0((Function1)new Function1<ClasspathPrinter, Unit>(name, project, path){
                    final /* synthetic */ String $name;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ FileCollection $path;
                    {
                        this.$name = $name;
                        this.$project = $project;
                        this.$path = $path;
                        super(1);
                    }

                    public final void invoke(ClasspathPrinter it) {
                        it.setGroup("OSGi");
                        it.setDescription("Displays the " + this.$name + " of project " + this.$project.getName() + '.');
                        it.getPathName().set((Object)this.$name);
                        Object[] objectArray = new Object[]{this.$path};
                        it.getClasspath().from(objectArray);
                    }
                }, arg_0));
            }
        }

        private static final void registerTasks$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

