/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.client;

import com.hazelcast.internal.nio.Connection;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.LazyDeserializer;
import com.hazelcast.sql.impl.LazyTarget;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.sql.impl.client.SqlFetchResult;
import com.hazelcast.sql.impl.client.SqlPage;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.Row;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public class SqlClientResult
implements SqlResult,
LazyDeserializer {
    private final SqlClientService service;
    private final Connection connection;
    private final QueryId queryId;
    private final int cursorBufferSize;
    private final Object mux = new Object();
    private State state;
    private boolean iteratorRequested;
    private boolean closed;
    private SqlFetchResult fetch;

    public SqlClientResult(SqlClientService service, Connection connection, QueryId queryId, int cursorBufferSize) {
        this.service = service;
        this.connection = connection;
        this.queryId = queryId;
        this.cursorBufferSize = cursorBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecuteResponse(SqlRowMetadata rowMetadata, SqlPage rowPage, long updateCount) {
        Object object = this.mux;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (rowMetadata != null) {
                ClientIterator iterator = new ClientIterator(rowMetadata);
                iterator.onNextPage(rowPage);
                this.state = new State(iterator, -1L, null);
            } else {
                this.state = new State(null, updateCount, null);
                this.markClosed();
            }
            this.mux.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecuteError(RuntimeException error) {
        Object object = this.mux;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.state = new State(null, -1L, error);
            this.mux.notifyAll();
        }
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    public SqlRowMetadata getRowMetadata() {
        State state = this.awaitState();
        ClientIterator iterator = state.iterator;
        if (iterator == null) {
            throw new IllegalStateException("This result contains only update count");
        }
        return iterator.rowMetadata;
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public Iterator<SqlRow> iterator() {
        State state = this.awaitState();
        ClientIterator iterator = state.iterator;
        if (iterator == null) {
            throw new IllegalStateException("This result contains only update count");
        }
        if (this.iteratorRequested) {
            throw new IllegalStateException("Iterator can be requested only once");
        }
        this.iteratorRequested = true;
        return iterator;
    }

    @Override
    public long updateCount() {
        State state = this.awaitState();
        return state.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mux;
        synchronized (object) {
            try {
                if (this.closed) {
                    return;
                }
                if (this.state == null) {
                    this.onExecuteError(QueryException.cancelledByUser());
                }
                if (this.fetch == null) {
                    this.fetch = new SqlFetchResult();
                }
                this.onFetchFinished(null, QueryException.cancelledByUser());
                this.service.close(this.connection, this.queryId);
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public Object deserialize(Object value) {
        return this.service.deserializeRowValue(value);
    }

    @Override
    public Object deserialize(LazyTarget value) {
        return this.service.deserializeRowValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markClosed() {
        Object object = this.mux;
        synchronized (object) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlPage fetch() {
        Object object = this.mux;
        synchronized (object) {
            if (this.fetch != null) {
                assert (this.fetch.getError() != null);
                throw this.wrap(this.fetch.getError());
            }
            this.fetch = new SqlFetchResult();
            this.service.fetchAsync(this.connection, this.queryId, this.cursorBufferSize, this);
            while (this.fetch.isPending()) {
                try {
                    this.mux.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw this.wrap(QueryException.error("Interrupted while waiting for the response from the server.", e));
                }
            }
            if (this.fetch.getError() != null) {
                throw this.wrap(this.fetch.getError());
            }
            SqlPage page = this.fetch.getPage();
            assert (page != null);
            this.fetch = null;
            return page;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFetchFinished(SqlPage page, RuntimeException error) {
        Object object = this.mux;
        synchronized (object) {
            assert (this.fetch != null && this.fetch.isPending());
            this.fetch.onResult(page, error);
            this.mux.notifyAll();
        }
    }

    private State awaitState() {
        State state = this.awaitStateNoThrow();
        if (state.error != null) {
            throw this.wrap(state.error);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State awaitStateNoThrow() {
        Object object = this.mux;
        synchronized (object) {
            while (this.state == null) {
                try {
                    this.mux.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    QueryException error = QueryException.error("Interrupted while waiting for the response from the server.", e);
                    return new State(null, -1L, error);
                }
            }
            return this.state;
        }
    }

    private HazelcastSqlException wrap(Throwable error) {
        throw QueryUtils.toPublicException(error, this.service.getClientId());
    }

    private final class ClientIterator
    implements Iterator<SqlRow> {
        private final SqlRowMetadata rowMetadata;
        private SqlPage currentPage;
        private int currentRowCount;
        private int currentPosition;
        private boolean last;

        private ClientIterator(SqlRowMetadata rowMetadata) {
            assert (rowMetadata != null);
            this.rowMetadata = rowMetadata;
        }

        @Override
        public boolean hasNext() {
            while (this.currentPosition == this.currentRowCount) {
                if (!this.last) {
                    SqlPage page = SqlClientResult.this.fetch();
                    this.onNextPage(page);
                    continue;
                }
                return false;
            }
            return true;
        }

        @Override
        public SqlRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Row row = this.getCurrentRow();
            ++this.currentPosition;
            return new SqlRowImpl(this.rowMetadata, row, SqlClientResult.this);
        }

        private void onNextPage(SqlPage page) {
            this.currentPage = page;
            this.currentRowCount = page.getRowCount();
            this.currentPosition = 0;
            if (page.isLast()) {
                this.last = true;
                SqlClientResult.this.markClosed();
            }
        }

        private Row getCurrentRow() {
            Object[] values = new Object[this.rowMetadata.getColumnCount()];
            for (int i = 0; i < this.currentPage.getColumnCount(); ++i) {
                values[i] = this.currentPage.getColumnValueForClient(i, this.currentPosition);
            }
            return new HeapRow(values);
        }
    }

    private static final class State {
        private final ClientIterator iterator;
        private final long updateCount;
        private final RuntimeException error;

        private State(ClientIterator iterator, long updateCount, RuntimeException error) {
            this.iterator = iterator;
            this.updateCount = updateCount;
            this.error = error;
        }
    }
}

