/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.io.github.classgraph;

import com.hazelcast.io.github.classgraph.ClassGraphException;
import com.hazelcast.io.github.classgraph.ModulePathInfo;
import com.hazelcast.io.github.classgraph.ModuleRef;
import com.hazelcast.io.github.classgraph.PackageInfo;
import com.hazelcast.io.github.classgraph.ScanResult;
import com.hazelcast.io.github.classgraph.Scanner;
import com.hazelcast.nonapi.io.github.classgraph.classpath.SystemJarFinder;
import com.hazelcast.nonapi.io.github.classgraph.concurrency.AutoCloseableExecutorService;
import com.hazelcast.nonapi.io.github.classgraph.concurrency.InterruptionChecker;
import com.hazelcast.nonapi.io.github.classgraph.scanspec.ScanSpec;
import com.hazelcast.nonapi.io.github.classgraph.scanspec.WhiteBlackList;
import com.hazelcast.nonapi.io.github.classgraph.utils.JarUtils;
import com.hazelcast.nonapi.io.github.classgraph.utils.LogNode;
import com.hazelcast.nonapi.io.github.classgraph.utils.VersionFinder;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public class ClassGraph {
    ScanSpec scanSpec = new ScanSpec();
    static final int DEFAULT_NUM_WORKER_THREADS = Math.max(2, (int)Math.ceil(Math.min(4.0, (double)Runtime.getRuntime().availableProcessors() * 0.75) + (double)Runtime.getRuntime().availableProcessors() * 1.25));
    private LogNode topLevelLog;

    public ClassGraph() {
        ScanResult.init();
    }

    public static String getVersion() {
        return VersionFinder.getVersion();
    }

    public ClassGraph verbose() {
        if (this.topLevelLog == null) {
            this.topLevelLog = new LogNode();
        }
        return this;
    }

    public ClassGraph verbose(boolean verbose) {
        if (verbose) {
            this.verbose();
        }
        return this;
    }

    public ClassGraph enableAllInfo() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.enableMethodInfo();
        this.enableAnnotationInfo();
        this.enableStaticFinalFieldConstantInitializerValues();
        this.ignoreClassVisibility();
        this.ignoreFieldVisibility();
        this.ignoreMethodVisibility();
        return this;
    }

    public ClassGraph enableClassInfo() {
        this.scanSpec.enableClassInfo = true;
        return this;
    }

    public ClassGraph ignoreClassVisibility() {
        this.enableClassInfo();
        this.scanSpec.ignoreClassVisibility = true;
        return this;
    }

    public ClassGraph enableMethodInfo() {
        this.enableClassInfo();
        this.scanSpec.enableMethodInfo = true;
        return this;
    }

    public ClassGraph ignoreMethodVisibility() {
        this.enableClassInfo();
        this.enableMethodInfo();
        this.scanSpec.ignoreMethodVisibility = true;
        return this;
    }

    public ClassGraph enableFieldInfo() {
        this.enableClassInfo();
        this.scanSpec.enableFieldInfo = true;
        return this;
    }

    public ClassGraph ignoreFieldVisibility() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.ignoreFieldVisibility = true;
        return this;
    }

    public ClassGraph enableStaticFinalFieldConstantInitializerValues() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.enableStaticFinalFieldConstantInitializerValues = true;
        return this;
    }

    public ClassGraph enableAnnotationInfo() {
        this.enableClassInfo();
        this.scanSpec.enableAnnotationInfo = true;
        return this;
    }

    public ClassGraph enableInterClassDependencies() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.enableMethodInfo();
        this.enableAnnotationInfo();
        this.ignoreClassVisibility();
        this.ignoreFieldVisibility();
        this.ignoreMethodVisibility();
        this.scanSpec.enableInterClassDependencies = true;
        return this;
    }

    public ClassGraph disableRuntimeInvisibleAnnotations() {
        this.enableClassInfo();
        this.scanSpec.disableRuntimeInvisibleAnnotations = true;
        return this;
    }

    public ClassGraph disableJarScanning() {
        this.scanSpec.scanJars = false;
        return this;
    }

    public ClassGraph disableNestedJarScanning() {
        this.scanSpec.scanNestedJars = false;
        return this;
    }

    public ClassGraph disableDirScanning() {
        this.scanSpec.scanDirs = false;
        return this;
    }

    public ClassGraph disableModuleScanning() {
        this.scanSpec.scanModules = false;
        return this;
    }

    public ClassGraph enableExternalClasses() {
        this.enableClassInfo();
        this.scanSpec.enableExternalClasses = true;
        return this;
    }

    public ClassGraph initializeLoadedClasses() {
        this.scanSpec.initializeLoadedClasses = true;
        return this;
    }

    public ClassGraph removeTemporaryFilesAfterScan() {
        this.scanSpec.removeTemporaryFilesAfterScan = true;
        return this;
    }

    public ClassGraph overrideClasspath(String overrideClasspath) {
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        for (String classpathElement : JarUtils.smartPathSplit(overrideClasspath, this.scanSpec)) {
            this.scanSpec.addClasspathOverride(classpathElement);
        }
        return this;
    }

    public ClassGraph overrideClasspath(Iterable<?> overrideClasspathElements) {
        if (!overrideClasspathElements.iterator().hasNext()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        for (Object classpathElement : overrideClasspathElements) {
            this.scanSpec.addClasspathOverride(classpathElement);
        }
        return this;
    }

    public ClassGraph overrideClasspath(Object ... overrideClasspathElements) {
        if (overrideClasspathElements.length == 0) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        for (Object classpathElement : overrideClasspathElements) {
            this.scanSpec.addClasspathOverride(classpathElement);
        }
        return this;
    }

    public ClassGraph filterClasspathElements(ClasspathElementFilter classpathElementFilter) {
        this.scanSpec.filterClasspathElements(classpathElementFilter);
        return this;
    }

    public ClassGraph addClassLoader(ClassLoader classLoader) {
        this.scanSpec.addClassLoader(classLoader);
        return this;
    }

    public ClassGraph overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.scanSpec.overrideClassLoaders(overrideClassLoaders);
        return this;
    }

    public ClassGraph ignoreParentClassLoaders() {
        this.scanSpec.ignoreParentClassLoaders = true;
        return this;
    }

    public ClassGraph addModuleLayer(Object moduleLayer) {
        this.scanSpec.addModuleLayer(moduleLayer);
        return this;
    }

    public ClassGraph overrideModuleLayers(Object ... overrideModuleLayers) {
        this.scanSpec.overrideModuleLayers(overrideModuleLayers);
        return this;
    }

    public ClassGraph ignoreParentModuleLayers() {
        this.scanSpec.ignoreParentModuleLayers = true;
        return this;
    }

    public ClassGraph whitelistPackages(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            String packageNameNormalized = WhiteBlackList.normalizePackageOrClassName(packageName);
            if (packageNameNormalized.startsWith("!") || packageNameNormalized.startsWith("-")) {
                throw new IllegalArgumentException("This style of whitelisting/blacklisting is no longer supported: " + packageNameNormalized);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(packageNameNormalized);
            String path = WhiteBlackList.packageNameToPath(packageNameNormalized);
            this.scanSpec.pathWhiteBlackList.addToWhitelist(path + "/");
            if (packageNameNormalized.isEmpty()) {
                this.scanSpec.pathWhiteBlackList.addToWhitelist("");
            }
            if (packageNameNormalized.contains("*")) continue;
            if (packageNameNormalized.isEmpty()) {
                this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist("");
                this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist("");
                continue;
            }
            this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist(packageNameNormalized + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist(path + "/");
        }
        return this;
    }

    public ClassGraph whitelistPaths(String ... paths) {
        for (String path : paths) {
            String pathNormalized = WhiteBlackList.normalizePath(path);
            String packageName = WhiteBlackList.pathToPackageName(pathNormalized);
            this.scanSpec.packageWhiteBlackList.addToWhitelist(packageName);
            this.scanSpec.pathWhiteBlackList.addToWhitelist(pathNormalized + "/");
            if (pathNormalized.isEmpty()) {
                this.scanSpec.pathWhiteBlackList.addToWhitelist("");
            }
            if (pathNormalized.contains("*")) continue;
            if (pathNormalized.isEmpty()) {
                this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist("");
                this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist("");
                continue;
            }
            this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist(packageName + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist(pathNormalized + "/");
        }
        return this;
    }

    public ClassGraph whitelistPackagesNonRecursive(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            String packageNameNormalized = WhiteBlackList.normalizePackageOrClassName(packageName);
            if (packageNameNormalized.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + packageNameNormalized);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(packageNameNormalized);
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageNameNormalized) + "/");
            if (!packageNameNormalized.isEmpty()) continue;
            this.scanSpec.pathWhiteBlackList.addToWhitelist("");
        }
        return this;
    }

    public ClassGraph whitelistPathsNonRecursive(String ... paths) {
        for (String path : paths) {
            if (path.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + path);
            }
            String pathNormalized = WhiteBlackList.normalizePath(path);
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.pathToPackageName(pathNormalized));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(pathNormalized + "/");
            if (!pathNormalized.isEmpty()) continue;
            this.scanSpec.pathWhiteBlackList.addToWhitelist("");
        }
        return this;
    }

    public ClassGraph blacklistPackages(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            String packageNameNormalized = WhiteBlackList.normalizePackageOrClassName(packageName);
            if (packageNameNormalized.isEmpty()) {
                throw new IllegalArgumentException("Blacklisting the root package (\"\") will cause nothing to be scanned");
            }
            this.scanSpec.packageWhiteBlackList.addToBlacklist(packageNameNormalized);
            String path = WhiteBlackList.packageNameToPath(packageNameNormalized);
            this.scanSpec.pathWhiteBlackList.addToBlacklist(path + "/");
            if (packageNameNormalized.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToBlacklist(packageNameNormalized + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToBlacklist(path + "/");
        }
        return this;
    }

    public ClassGraph blacklistPaths(String ... paths) {
        for (String path : paths) {
            String pathNormalized = WhiteBlackList.normalizePath(path);
            if (pathNormalized.isEmpty()) {
                throw new IllegalArgumentException("Blacklisting the root package (\"\") will cause nothing to be scanned");
            }
            String packageName = WhiteBlackList.pathToPackageName(pathNormalized);
            this.scanSpec.packageWhiteBlackList.addToBlacklist(packageName);
            this.scanSpec.pathWhiteBlackList.addToBlacklist(pathNormalized + "/");
            if (pathNormalized.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToBlacklist(packageName + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToBlacklist(pathNormalized + "/");
        }
        return this;
    }

    public ClassGraph whitelistClasses(String ... classNames) {
        this.enableClassInfo();
        for (String className : classNames) {
            if (className.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + className);
            }
            String classNameNormalized = WhiteBlackList.normalizePackageOrClassName(className);
            this.scanSpec.classWhiteBlackList.addToWhitelist(classNameNormalized);
            this.scanSpec.classfilePathWhiteBlackList.addToWhitelist(WhiteBlackList.classNameToClassfilePath(classNameNormalized));
            String packageName = PackageInfo.getParentPackageName(classNameNormalized);
            this.scanSpec.classPackageWhiteBlackList.addToWhitelist(packageName);
            this.scanSpec.classPackagePathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName) + "/");
        }
        return this;
    }

    public ClassGraph blacklistClasses(String ... classNames) {
        this.enableClassInfo();
        for (String className : classNames) {
            if (className.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + className);
            }
            String classNameNormalized = WhiteBlackList.normalizePackageOrClassName(className);
            this.scanSpec.classWhiteBlackList.addToBlacklist(classNameNormalized);
            this.scanSpec.classfilePathWhiteBlackList.addToBlacklist(WhiteBlackList.classNameToClassfilePath(classNameNormalized));
        }
        return this;
    }

    public ClassGraph whitelistJars(String ... jarLeafNames) {
        for (String jarLeafName : jarLeafNames) {
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only whitelist jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarWhiteBlackList.addToWhitelist(leafName);
        }
        return this;
    }

    public ClassGraph blacklistJars(String ... jarLeafNames) {
        for (String jarLeafName : jarLeafNames) {
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only blacklist jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarWhiteBlackList.addToBlacklist(leafName);
        }
        return this;
    }

    private void whitelistOrBlacklistLibOrExtJars(boolean whitelist, String ... jarLeafNames) {
        if (jarLeafNames.length == 0) {
            for (String libOrExtJar : SystemJarFinder.getJreLibOrExtJars()) {
                this.whitelistOrBlacklistLibOrExtJars(whitelist, JarUtils.leafName(libOrExtJar));
            }
        } else {
            for (String jarLeafName : jarLeafNames) {
                String leafName = JarUtils.leafName(jarLeafName);
                if (!leafName.equals(jarLeafName)) {
                    throw new IllegalArgumentException("Can only " + (whitelist ? "whitelist" : "blacklist") + " jars by leafname: " + jarLeafName);
                }
                if (jarLeafName.contains("*")) {
                    Pattern pattern = WhiteBlackList.globToPattern(jarLeafName);
                    boolean found = false;
                    for (String libOrExtJarPath : SystemJarFinder.getJreLibOrExtJars()) {
                        String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                        if (!pattern.matcher(libOrExtJarLeafName).matches()) continue;
                        if (!libOrExtJarLeafName.contains("*")) {
                            this.whitelistOrBlacklistLibOrExtJars(whitelist, libOrExtJarLeafName);
                        }
                        found = true;
                    }
                    if (found || this.topLevelLog == null) continue;
                    this.topLevelLog.log("Could not find lib or ext jar matching wildcard: " + jarLeafName);
                    continue;
                }
                boolean found = false;
                for (String libOrExtJarPath : SystemJarFinder.getJreLibOrExtJars()) {
                    String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                    if (!jarLeafName.equals(libOrExtJarLeafName)) continue;
                    if (whitelist) {
                        this.scanSpec.libOrExtJarWhiteBlackList.addToWhitelist(jarLeafName);
                    } else {
                        this.scanSpec.libOrExtJarWhiteBlackList.addToBlacklist(jarLeafName);
                    }
                    if (this.topLevelLog != null) {
                        this.topLevelLog.log((whitelist ? "Whitelisting" : "Blacklisting") + " lib or ext jar: " + libOrExtJarPath);
                    }
                    found = true;
                    break;
                }
                if (found || this.topLevelLog == null) continue;
                this.topLevelLog.log("Could not find lib or ext jar: " + jarLeafName);
            }
        }
    }

    public ClassGraph whitelistLibOrExtJars(String ... jarLeafNames) {
        this.whitelistOrBlacklistLibOrExtJars(true, jarLeafNames);
        return this;
    }

    public ClassGraph blacklistLibOrExtJars(String ... jarLeafNames) {
        this.whitelistOrBlacklistLibOrExtJars(false, jarLeafNames);
        return this;
    }

    public ClassGraph whitelistModules(String ... moduleNames) {
        for (String moduleName : moduleNames) {
            this.scanSpec.moduleWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(moduleName));
        }
        return this;
    }

    public ClassGraph blacklistModules(String ... moduleNames) {
        for (String moduleName : moduleNames) {
            this.scanSpec.moduleWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePackageOrClassName(moduleName));
        }
        return this;
    }

    public ClassGraph whitelistClasspathElementsContainingResourcePath(String ... resourcePaths) {
        for (String resourcePath : resourcePaths) {
            String resourcePathNormalized = WhiteBlackList.normalizePath(resourcePath);
            this.scanSpec.classpathElementResourcePathWhiteBlackList.addToWhitelist(resourcePathNormalized);
        }
        return this;
    }

    public ClassGraph blacklistClasspathElementsContainingResourcePath(String ... resourcePaths) {
        for (String resourcePath : resourcePaths) {
            String resourcePathNormalized = WhiteBlackList.normalizePath(resourcePath);
            this.scanSpec.classpathElementResourcePathWhiteBlackList.addToBlacklist(resourcePathNormalized);
        }
        return this;
    }

    public ClassGraph enableRemoteJarScanning() {
        this.scanSpec.enableURLScheme("http");
        this.scanSpec.enableURLScheme("https");
        return this;
    }

    public ClassGraph enableURLScheme(String scheme) {
        this.scanSpec.enableURLScheme(scheme);
        return this;
    }

    public ClassGraph enableSystemJarsAndModules() {
        this.enableClassInfo();
        this.scanSpec.enableSystemJarsAndModules = true;
        return this;
    }

    public ClassGraph setMaxBufferedJarRAMSize(int maxBufferedJarRAMSize) {
        this.scanSpec.maxBufferedJarRAMSize = maxBufferedJarRAMSize;
        return this;
    }

    public ClassGraph enableMemoryMapping() {
        this.scanSpec.enableMemoryMapping = true;
        return this;
    }

    public ClassGraph enableRealtimeLogging() {
        this.verbose();
        LogNode.logInRealtime(true);
        return this;
    }

    public void scanAsync(final ExecutorService executorService, final int numParallelTasks, final ScanResultProcessor scanResultProcessor, final FailureHandler failureHandler) {
        if (scanResultProcessor == null) {
            throw new IllegalArgumentException("scanResultProcessor cannot be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("failureHandler cannot be null");
        }
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    new Scanner(true, ClassGraph.this.scanSpec, executorService, numParallelTasks, scanResultProcessor, failureHandler, ClassGraph.this.topLevelLog).call();
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    failureHandler.onFailure(e);
                }
            }
        });
    }

    private Future<ScanResult> scanAsync(boolean performScan, ExecutorService executorService, int numParallelTasks) {
        try {
            return executorService.submit(new Scanner(performScan, this.scanSpec, executorService, numParallelTasks, null, null, this.topLevelLog));
        }
        catch (InterruptedException e) {
            return executorService.submit(new Callable<ScanResult>(){

                @Override
                public ScanResult call() throws Exception {
                    throw e;
                }
            });
        }
    }

    public Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks) {
        return this.scanAsync(true, executorService, numParallelTasks);
    }

    public ScanResult scan(ExecutorService executorService, int numParallelTasks) {
        try {
            ScanResult scanResult = this.scanAsync(executorService, numParallelTasks).get();
            if (scanResult == null) {
                throw new NullPointerException();
            }
            return scanResult;
        }
        catch (InterruptedException | CancellationException e) {
            throw ClassGraphException.newClassGraphException("Scan interrupted", e);
        }
        catch (ExecutionException e) {
            throw ClassGraphException.newClassGraphException("Uncaught exception during scan", InterruptionChecker.getCause(e));
        }
    }

    public ScanResult scan(int numThreads) {
        try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(numThreads);){
            ScanResult scanResult = this.scan(executorService, numThreads);
            return scanResult;
        }
    }

    public ScanResult scan() {
        return this.scan(DEFAULT_NUM_WORKER_THREADS);
    }

    ScanResult getClasspathScanResult(AutoCloseableExecutorService executorService) {
        try {
            ScanResult scanResult = this.scanAsync(false, executorService, DEFAULT_NUM_WORKER_THREADS).get();
            if (scanResult == null) {
                throw new NullPointerException();
            }
            return scanResult;
        }
        catch (InterruptedException | CancellationException e) {
            throw ClassGraphException.newClassGraphException("Scan interrupted", e);
        }
        catch (ExecutionException e) {
            throw ClassGraphException.newClassGraphException("Uncaught exception during scan", InterruptionChecker.getCause(e));
        }
    }

    /*
     * Exception decompiling
     */
    public List<File> getClasspathFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getClasspath() {
        return JarUtils.pathElementsToPathStr(this.getClasspathFiles());
    }

    /*
     * Exception decompiling
     */
    public List<URI> getClasspathURIs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<URL> getClasspathURLs() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<ModuleRef> getModules() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ModulePathInfo getModulePathInfo() {
        return this.scanSpec.modulePathInfo;
    }

    @FunctionalInterface
    public static interface FailureHandler {
        public void onFailure(Throwable var1);
    }

    @FunctionalInterface
    public static interface ScanResultProcessor {
        public void processScanResult(ScanResult var1);
    }

    @FunctionalInterface
    public static interface ClasspathElementFilter {
        public boolean includeClasspathElement(String var1);
    }
}

