/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.nio.serialization.FieldType;
import javax.annotation.Nonnull;

public class FieldDescriptor {
    private final String fieldName;
    private final FieldType type;
    private int index = -1;
    private int offset = -1;
    private byte bitOffset = (byte)-1;

    public FieldDescriptor(@Nonnull String fieldName, @Nonnull FieldType type) {
        this.fieldName = fieldName;
        this.type = type;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setBitOffset(byte bitOffset) {
        this.bitOffset = bitOffset;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte getBitOffset() {
        return this.bitOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDescriptor that = (FieldDescriptor)o;
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "FieldDefinitionImpl{fieldName='" + this.fieldName + '\'' + ", type=" + (Object)((Object)this.type) + ", index=" + this.index + ", offset=" + this.offset + ", bitOffset=" + this.bitOffset + '}';
    }
}

