/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.query.extractor.ValueCallback;
import com.hazelcast.query.extractor.ValueCollector;
import com.hazelcast.query.extractor.ValueReader;
import com.hazelcast.query.extractor.ValueReadingException;
import com.hazelcast.query.impl.getters.ExtractorHelper;
import com.hazelcast.query.impl.getters.MultiResult;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.function.Consumer;

public final class GenericRecordQueryReader
implements ValueReader {
    private final InternalGenericRecord rootRecord;

    public GenericRecordQueryReader(InternalGenericRecord rootRecord) {
        this.rootRecord = rootRecord;
    }

    public void read(String path, ValueCallback callback) {
        this.read(path, callback::onResult);
    }

    public void read(String path, ValueCollector collector) {
        this.read(path, collector::addObject);
    }

    private void read(String path, Consumer consumer) {
        try {
            Object result = this.read(path);
            if (result instanceof MultiResult) {
                MultiResult multiResult = (MultiResult)result;
                for (Object singleResult : multiResult.getResults()) {
                    consumer.accept(singleResult);
                }
            } else {
                consumer.accept(result);
            }
        }
        catch (IOException e) {
            throw new ValueReadingException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new ValueReadingException(e.getMessage(), e);
        }
    }

    public Object read(String fieldPath) throws IOException {
        GenericRecord record;
        String fieldName;
        ListIterator<Object> iterator;
        String path;
        if (fieldPath == null) {
            throw new IllegalArgumentException("field path can not be null");
        }
        if (fieldPath.endsWith(".")) {
            throw new IllegalArgumentException("Malformed path " + fieldPath);
        }
        if (this.rootRecord.hasField(fieldPath)) {
            return this.readLeaf(this.rootRecord, fieldPath);
        }
        LinkedList<InternalGenericRecord> results = new LinkedList<InternalGenericRecord>();
        results.add(this.rootRecord);
        MultiResult multiResult = new MultiResult(results);
        int begin = 0;
        int end = StringUtil.indexOf(fieldPath, '.');
        while (end != -1) {
            path = fieldPath.substring(begin, end);
            if (path.length() == 0) {
                throw new IllegalArgumentException("The token's length cannot be zero: " + fieldPath);
            }
            begin = end + 1;
            end = StringUtil.indexOf(fieldPath, '.', begin);
            iterator = results.listIterator();
            fieldName = ExtractorHelper.extractAttributeNameNameWithoutArguments(path);
            if (!path.contains("]")) {
                while (iterator.hasNext()) {
                    InternalGenericRecord record2 = (InternalGenericRecord)iterator.next();
                    if (!record2.hasField(fieldName)) {
                        iterator.remove();
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    InternalGenericRecord subGenericRecord = (InternalGenericRecord)record2.getGenericRecord(fieldName);
                    if (subGenericRecord == null) {
                        iterator.remove();
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    iterator.set(subGenericRecord);
                }
                continue;
            }
            if (path.endsWith("[any]")) {
                while (iterator.hasNext()) {
                    InternalGenericRecord record3 = (InternalGenericRecord)iterator.next();
                    iterator.remove();
                    if (!record3.hasField(fieldName)) {
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    GenericRecord[] genericRecords = record3.getGenericRecordArray(fieldName);
                    if (genericRecords == null || genericRecords.length == 0) {
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    for (GenericRecord genericRecord : genericRecords) {
                        if (genericRecord != null) {
                            iterator.add(genericRecord);
                            continue;
                        }
                        multiResult.setNullOrEmptyTarget(true);
                    }
                }
                continue;
            }
            int index = Integer.parseInt(ExtractorHelper.extractArgumentsFromAttributeName(path));
            while (iterator.hasNext()) {
                record = (InternalGenericRecord)iterator.next();
                if (!record.hasField(fieldName)) {
                    iterator.remove();
                    multiResult.setNullOrEmptyTarget(true);
                    continue;
                }
                GenericRecord genericRecord = record.getGenericRecordFromArray(fieldName, index);
                if (genericRecord != null) {
                    iterator.set(genericRecord);
                    continue;
                }
                iterator.remove();
                multiResult.setNullOrEmptyTarget(true);
            }
        }
        path = fieldPath.substring(begin);
        if (path.length() == 0) {
            throw new IllegalArgumentException("The token's length cannot be zero: " + fieldPath);
        }
        iterator = results.listIterator();
        fieldName = ExtractorHelper.extractAttributeNameNameWithoutArguments(path);
        if (!path.contains("]")) {
            while (iterator.hasNext()) {
                InternalGenericRecord record4 = (InternalGenericRecord)iterator.next();
                Object leaf = this.readLeaf(record4, fieldName);
                iterator.set(leaf);
            }
        } else if (path.endsWith("[any]")) {
            while (iterator.hasNext()) {
                InternalGenericRecord record5 = (InternalGenericRecord)iterator.next();
                iterator.remove();
                Object leaves = this.readLeaf(record5, fieldName);
                if (leaves == null) {
                    multiResult.setNullOrEmptyTarget(true);
                    continue;
                }
                if (leaves instanceof Object[]) {
                    Object[] array = (Object[])leaves;
                    if (array.length == 0) {
                        multiResult.setNullOrEmptyTarget(true);
                        continue;
                    }
                    for (Object leaf : array) {
                        iterator.add(leaf);
                    }
                    continue;
                }
                assert (leaves.getClass().isArray()) : "parameter is not an array";
                if (ExtractorHelper.reducePrimitiveArrayInto(iterator::add, leaves)) continue;
                multiResult.setNullOrEmptyTarget(true);
            }
        } else {
            int index = Integer.parseInt(ExtractorHelper.extractArgumentsFromAttributeName(path));
            while (iterator.hasNext()) {
                record = (GenericRecord)iterator.next();
                Object leaf = this.readIndexed((InternalGenericRecord)record, fieldName, index);
                iterator.set(leaf);
            }
        }
        if (multiResult.isNullEmptyTarget()) {
            results.addFirst(null);
        } else if (results.size() == 1) {
            return results.get(0);
        }
        return multiResult;
    }

    private Object readIndexed(InternalGenericRecord record, String path, int index) {
        if (!record.hasField(path)) {
            return null;
        }
        FieldType type = record.getFieldType(path);
        return FieldOperations.fieldOperations(type).readIndexed(record, path, index);
    }

    private Object readLeaf(InternalGenericRecord record, String path) {
        if (!record.hasField(path)) {
            return null;
        }
        FieldType type = record.getFieldType(path);
        return FieldOperations.fieldOperations(type).readObject(record, path);
    }
}

