/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.FragmentedMigrationAwareService;
import com.hazelcast.internal.partition.MigrationAwareService;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.OffloadedReplicationPreparation;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.internal.partition.operation.UrgentPartitionRunnable;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

abstract class AbstractPartitionOperation
extends Operation
implements IdentifiedDataSerializable {
    AbstractPartitionOperation() {
    }

    final Collection<MigrationAwareService> getMigrationAwareServices() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        return nodeEngine.getServices(MigrationAwareService.class);
    }

    final Collection<Operation> createAllReplicationOperations(PartitionReplicationEvent event) {
        return this.createReplicationOperations(event, false);
    }

    final Collection<Operation> createNonFragmentedReplicationOperations(PartitionReplicationEvent event) {
        if (ThreadUtil.isRunningOnPartitionThread()) {
            return this.createReplicationOperations(event, true);
        }
        UrgentPartitionRunnable runnable = new UrgentPartitionRunnable(event.getPartitionId(), () -> this.createReplicationOperations(event, true));
        this.getNodeEngine().getOperationService().execute(runnable);
        return (Collection)runnable.future.joinInternal();
    }

    private Collection<Operation> createReplicationOperations(PartitionReplicationEvent event, boolean nonFragmentedOnly) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<ServiceInfo> services = nodeEngine.getServiceInfos(MigrationAwareService.class);
        for (ServiceInfo serviceInfo : services) {
            Operation op;
            MigrationAwareService service = (MigrationAwareService)serviceInfo.getService();
            if (nonFragmentedOnly && service instanceof FragmentedMigrationAwareService || (op = service.prepareReplicationOperation(event)) == null) continue;
            op.setServiceName(serviceInfo.getName());
            operations.add(op);
        }
        return operations;
    }

    final Collection<Operation> createFragmentReplicationOperations(PartitionReplicationEvent event, ServiceNamespace ns) {
        assert (!(ns instanceof NonFragmentedServiceNamespace)) : ns + " should be used only for fragmented services!";
        ThreadUtil.assertRunningOnPartitionThread();
        Collection<Operation> operations = Collections.emptySet();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<ServiceInfo> services = nodeEngine.getServiceInfos(FragmentedMigrationAwareService.class);
        for (ServiceInfo serviceInfo : services) {
            FragmentedMigrationAwareService service = (FragmentedMigrationAwareService)serviceInfo.getService();
            if (!service.isKnownServiceNamespace(ns)) continue;
            operations = this.prepareAndAppendReplicationOperation(event, ns, service, serviceInfo.getName(), operations);
        }
        return operations;
    }

    final Collection<Operation> createFragmentReplicationOperationsOffload(PartitionReplicationEvent event, ServiceNamespace ns, Collection<String> serviceNames) {
        assert (!(ns instanceof NonFragmentedServiceNamespace)) : ns + " should be used only for fragmented services!";
        Collection<Operation> operations = Collections.emptySet();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        for (String serviceName : serviceNames) {
            FragmentedMigrationAwareService service = (FragmentedMigrationAwareService)nodeEngine.getService(serviceName);
            assert (service.isKnownServiceNamespace(ns)) : ns + " should be known by " + service;
            operations = this.collectReplicationOperations(event, ns, ThreadUtil.isRunningOnPartitionThread(), operations, serviceName, service);
        }
        return operations;
    }

    final Collection<Operation> createFragmentReplicationOperationsOffload(PartitionReplicationEvent event, ServiceNamespace ns) {
        assert (!(ns instanceof NonFragmentedServiceNamespace)) : ns + " should be used only for fragmented services!";
        Collection<Operation> operations = Collections.emptySet();
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        Collection<ServiceInfo> services = nodeEngine.getServiceInfos(FragmentedMigrationAwareService.class);
        for (ServiceInfo serviceInfo : services) {
            FragmentedMigrationAwareService service = (FragmentedMigrationAwareService)serviceInfo.getService();
            if (!service.isKnownServiceNamespace(ns)) continue;
            operations = this.collectReplicationOperations(event, ns, ThreadUtil.isRunningOnPartitionThread(), operations, serviceInfo.getName(), service);
        }
        return operations;
    }

    @Nullable
    private Collection<Operation> collectReplicationOperations(PartitionReplicationEvent event, ServiceNamespace ns, boolean runsOnPartitionThread, Collection<Operation> operations, String serviceName, FragmentedMigrationAwareService service) {
        if (runsOnPartitionThread ^ (service instanceof OffloadedReplicationPreparation && ((OffloadedReplicationPreparation)((Object)service)).shouldOffload())) {
            operations = this.prepareAndAppendReplicationOperation(event, ns, service, serviceName, operations);
        } else if (runsOnPartitionThread) {
            Future<Operation> future = this.getNodeEngine().getExecutionService().submit("hz:async", () -> this.prepareReplicationOperation(event, ns, service, serviceName));
            try {
                Operation op = future.get();
                operations = this.appendOperation(operations, op);
            }
            catch (CancellationException | ExecutionException e) {
                ExceptionUtil.rethrow(e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                ExceptionUtil.rethrow(e);
            }
        } else {
            UrgentPartitionRunnable partitionThreadRunnable = new UrgentPartitionRunnable(event.getPartitionId(), () -> this.prepareReplicationOperation(event, ns, service, serviceName));
            this.getNodeEngine().getOperationService().execute(partitionThreadRunnable);
            Operation op = (Operation)partitionThreadRunnable.future.joinInternal();
            operations = this.appendOperation(operations, op);
        }
        return operations;
    }

    private Collection<Operation> appendOperation(Collection<Operation> previous, Operation additional) {
        if (additional == null) {
            return previous;
        }
        if (previous.isEmpty()) {
            previous = Collections.singleton(additional);
        } else if (previous.size() == 1) {
            previous = this.newOperationSet(previous);
            previous.add(additional);
        } else {
            previous.add(additional);
        }
        return previous;
    }

    private Operation prepareReplicationOperation(PartitionReplicationEvent event, ServiceNamespace ns, FragmentedMigrationAwareService service, String serviceName) {
        Operation op = service.prepareReplicationOperation(event, Collections.singleton(ns));
        if (op == null) {
            return null;
        }
        op.setServiceName(serviceName);
        return op;
    }

    private Collection<Operation> prepareAndAppendReplicationOperation(PartitionReplicationEvent event, ServiceNamespace ns, FragmentedMigrationAwareService service, String serviceName, Collection<Operation> operations) {
        Operation op = service.prepareReplicationOperation(event, Collections.singleton(ns));
        if (op == null) {
            return operations;
        }
        op.setServiceName(serviceName);
        if (operations.isEmpty()) {
            operations = Collections.singleton(op);
        } else if (operations.size() == 1) {
            operations = this.newOperationSet(operations);
            operations.add(op);
        } else {
            operations.add(op);
        }
        return operations;
    }

    @Override
    public final int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    Set<Operation> newOperationSet(Collection<Operation> previous) {
        Set<Operation> newSet = Collections.newSetFromMap(new ConcurrentHashMap());
        newSet.addAll(previous);
        return newSet;
    }
}

