/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.exception;

import com.hazelcast.cp.exception.CPSubsystemException;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import java.util.Collection;
import java.util.UUID;

public class MismatchingGroupMembersCommitIndexException
extends CPSubsystemException {
    private static final long serialVersionUID = -109570074579015635L;
    private final long commitIndex;
    private final Collection<RaftEndpoint> members;

    public MismatchingGroupMembersCommitIndexException(long commitIndex, Collection<RaftEndpoint> members) {
        super("commit index: " + commitIndex + " members: " + members, (UUID)null);
        this.commitIndex = commitIndex;
        this.members = members;
    }

    private MismatchingGroupMembersCommitIndexException(long commitIndex, Collection<RaftEndpoint> members, Throwable cause) {
        super("commit index: " + commitIndex + " members: " + members, cause, null);
        this.commitIndex = commitIndex;
        this.members = members;
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public Collection<RaftEndpoint> getMembers() {
        return this.members;
    }

    @Override
    public MismatchingGroupMembersCommitIndexException wrap() {
        return new MismatchingGroupMembersCommitIndexException(this.commitIndex, this.members, this);
    }
}

