/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.data;

import com.openexchange.osgi.data.Classpath;
import com.openexchange.osgi.data.OSGIManifest;
import com.openexchange.osgi.worker.handler.ProjectHandler;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/openexchange/osgi/data/SourceModule;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "name", "", "manifest", "Lcom/openexchange/osgi/data/OSGIManifest;", "(Ljava/lang/String;Lcom/openexchange/osgi/data/OSGIManifest;)V", "classPath", "Lcom/openexchange/osgi/data/Classpath;", "getClassPath", "()Lcom/openexchange/osgi/data/Classpath;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "getManifest", "()Lcom/openexchange/osgi/data/OSGIManifest;", "getName", "()Ljava/lang/String;", "projectPath", "getProjectPath", "osgi"})
public final class SourceModule {
    @NotNull
    private final String name;
    @NotNull
    private final File file;
    @NotNull
    private final String projectPath;
    @NotNull
    private final OSGIManifest manifest;
    @Nullable
    private final Classpath classPath;

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final String getProjectPath() {
        return this.projectPath;
    }

    @NotNull
    public final OSGIManifest getManifest() {
        return this.manifest;
    }

    @Nullable
    public final Classpath getClassPath() {
        return this.classPath;
    }

    public SourceModule(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        this.name = StringsKt.substringAfterLast$default((String)string, (String)":", null, (int)2, null);
        File file = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        this.file = file;
        String string2 = project.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.path");
        this.projectPath = string2;
        this.manifest = new OSGIManifest(FilesKt.resolve((File)this.file, (String)"META-INF/MANIFEST.MF"));
        this.classPath = ProjectHandler.Companion.getClasspath(project);
    }

    public SourceModule(@NotNull String name, @NotNull OSGIManifest manifest) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        this.name = name;
        this.file = new File(".");
        this.projectPath = name;
        this.manifest = manifest;
        this.classPath = null;
    }
}

