/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.ant;

import com.openexchange.osgi.Tools;
import com.openexchange.osgi.data.AbstractModule;
import com.openexchange.osgi.data.DirModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class SetBundleProperties
extends Task {
    private File dir;
    private String currentBundle;
    private String buildType;
    private Path classpath;

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setCurrentBundle(String currentBundle) {
        this.currentBundle = currentBundle;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public Path createClasspath() {
        this.classpath = new Path(this.getProject());
        return this.classpath;
    }

    public void execute() throws BuildException {
        DirModule module;
        List<AbstractModule> classpathModules;
        this.log("using classpath: " + this.classpath, 4);
        try {
            classpathModules = com.openexchange.osgi.ant.Tools.readClasspathModules(this.classpath);
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        try {
            module = Tools.readModule(classpathModules, new File(this.dir, this.currentBundle));
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        ArrayList<AbstractModule> allModules = new ArrayList<AbstractModule>(classpathModules.size() + 1);
        allModules.addAll(classpathModules);
        allModules.add(module);
        for (AbstractModule tmpModule : allModules) {
            try {
                tmpModule.computeDependencies(Tools.calculateModulesByName(allModules), Tools.calculateModulesByPackage(allModules), Tools.calculateModulesByFilename(allModules), true);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        com.openexchange.osgi.ant.Tools.setProjectProperties(this.getProject(), module, this.buildType);
    }
}

