%define configfiles configfiles.list
%define manlist manfiles.list
%define __jar_repack %{nil}

Name:          open-xchange-core
BuildArch:     noarch
BuildRequires: ant
BuildRequires: open-xchange-osgi
BuildRequires: open-xchange-xerces
BuildRequires: open-xchange-hazelcast
BuildRequires: java-1.8.0-openjdk-devel
BuildRequires: pandoc >= 2.0.0
Version:       7.10.6
%define        ox_release 84
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       AGPLv3+
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       The essential core of an Open-Xchange backend
Autoreqprov:   no
Requires(post): patch
Requires:      open-xchange-osgi >= 7.10.6
Requires:      open-xchange-xerces >= 7.10.6
Requires:      open-xchange-hazelcast
Requires(pre): open-xchange-system >= 7.10.6
Requires:      open-xchange-system >= 7.10.6
Obsoletes:     open-xchange-freebusy < %{version}
Conflicts:     open-xchange-publish < 7.10.2
Obsoletes:     open-xchange-publish < 7.10.2
Conflicts:     open-xchange-geoip-ip2location < 7.10.3
Obsoletes:     open-xchange-geoip-ip2location < 7.10.3
Obsoletes:     open-xchange-filestore-swift < 7.10.4
Conflicts:     open-xchange-guard < 2.10.7
Conflicts:     open-xchange-mobile-api-facade
Obsoletes:     open-xchange-mobile-api-facade
Conflicts:     open-xchange-mobile-api-facade-push-certificates
Obsoletes:     open-xchange-mobile-api-facade-push-certificates

%description
This package installs all essential bundles that are necessary to get a working backend installation. This are the bundles for the main
modules of Open-Xchange: Mail, Calendar, Contacts, Tasks and InfoStore. Additionally the following functionalities are installed with this
package:
* the main caching system using the Java Caching System (JCS)
* the config cascade allowing administrators to selectively override configuration parameters on context and user level
* the contact collector storing every contact of read or written emails in a special collected contacts folder
* the conversion engine converting vCard or iCal email attachments to contacts or appointments
* the import and export module to import or export complete contact or appointment folders
* the iMIP implementation to handle invitations with participants through emails
* auto configuration for external email accounts
* encrypted storing of passwords for integrated social accounts
* and a lot more

Authors:
--------
    Open-Xchange

%prep

%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build
mkdir -p %{buildroot}/var/log/open-xchange
mkdir -p %{buildroot}/var/spool/open-xchange/uploads
rm -f %{configfiles}
find %{buildroot}/opt/open-xchange/etc \
     %{buildroot}/opt/open-xchange/importCSV \
        \( -path %{buildroot}/opt/open-xchange/etc/security/policies.policy -o ! -path "%{buildroot}/opt/open-xchange/etc/security*" \) \
        ! -path %{buildroot}/opt/open-xchange/etc/all.policy \
        -type f \
        -printf "%%%config(noreplace) %p\n" > %{configfiles}
perl -pi -e 's;%{buildroot};;' %{configfiles}
perl -pi -e 's;^(.*?)\s+(.*/paths.perfMap)$;$2;' %{configfiles}
perl -pi -e 's;(^.*?)\s+(.*/(autoconfig|mail|configdb|server|filestorage|management|secret|sessiond)\.properties)$;$1 %%%attr(640,root,open-xchange) $2;' %{configfiles}
perl -pi -e 's;(^.*?)\s+(.*/(secrets|tokenlogin-secrets))$;$1 %%%attr(640,root,open-xchange) $2;' %{configfiles}
rm -f %{manlist} && touch %{manlist}
test -d %{buildroot}%{_mandir} && find %{buildroot}%{_mandir}/man1 -type f -printf "%%%doc %p.*\n" >> %{manlist}
sed -i -e 's;%{buildroot};;' %{manlist}
cat %{manlist} >> %{configfiles}

%post
. /opt/open-xchange/lib/oxfunctions.sh
if [ ${1:-0} -eq 2 ]; then
    # only when updating

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    # Fix for bug 25999
    ox_remove_property com.openexchange.servlet.sessionCleanerInterval /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-2456
    ox_add_property com.openexchange.caching.jcs.remoteInvalidationForPersonalFolders false /opt/open-xchange/etc/cache.properties

    # SoftwareChange_Request-2464
    ox_add_property com.openexchange.hazelcast.shutdownOnOutOfMemory false /opt/open-xchange/etc/hazelcast.properties

    # SoftwareChange_Request-2541
    VALUE=$(ox_read_property com.openexchange.hazelcast.maxOperationTimeout /opt/open-xchange/etc/hazelcast.properties)
    if [ "5000" = "$VALUE" ]; then
        ox_set_property com.openexchange.hazelcast.maxOperationTimeout 30000 /opt/open-xchange/etc/hazelcast.properties
    fi

    # SoftwareChange_Request-2546
    VALUE=$(ox_read_property com.openexchange.push.allowedClients /opt/open-xchange/etc/mail-push.properties)
    if [ "\"USM-EAS*\", \"USM-JSON*\"" = "$VALUE" ]; then
        ox_set_property com.openexchange.push.allowedClients "\"USM-EAS*\", \"USM-JSON*\", \"open-xchange-mailapp\"" /opt/open-xchange/etc/mail-push.properties
    fi
    ox_add_property com.openexchange.push.allowPermanentPush true /opt/open-xchange/etc/mail-push.properties
    ox_add_property com.openexchange.push.credstorage.enabled false /opt/open-xchange/etc/mail-push.properties
    ox_add_property com.openexchange.push.credstorage.passcrypt "" /opt/open-xchange/etc/mail-push.properties
    ox_add_property com.openexchange.push.credstorage.rdb false /opt/open-xchange/etc/mail-push.properties

    # SoftwareChange_Request-2549
    VALUE=$(ox_read_property com.openexchange.IPCheckWhitelist /opt/open-xchange/etc/server.properties)
    if [ "" = "$VALUE" ]; then
        ox_set_property com.openexchange.IPCheckWhitelist "\"open-xchange-mailapp\"" /opt/open-xchange/etc/server.properties
    fi

    # SoftwareChange_Request-2568
    ox_add_property com.openexchange.contact.storeVCards true /opt/open-xchange/etc/contact.properties
    ox_add_property com.openexchange.contact.maxVCardSize 4194304 /opt/open-xchange/etc/contact.properties

    # SoftwareChange_Request-2575
    ox_add_property com.openexchange.capability.mobile_mail_app false /opt/open-xchange/etc/permissions.properties

    # SoftwareChange_Request-2630
    ox_add_property com.openexchange.capability.share_links true /opt/open-xchange/etc/permissions.properties
    ox_add_property com.openexchange.capability.invite_guests true /opt/open-xchange/etc/permissions.properties

    # SoftwareChange_Request-2652
    ox_add_property com.openexchange.contact.image.scaleImages true /opt/open-xchange/etc/contact.properties
    ox_add_property com.openexchange.contact.image.maxWidth 250 /opt/open-xchange/etc/contact.properties
    ox_add_property com.openexchange.contact.image.maxHeight 250 /opt/open-xchange/etc/contact.properties
    ox_add_property com.openexchange.contact.image.scaleType 2 /opt/open-xchange/etc/contact.properties

    # SoftwareChange_Request-2662
    ox_add_property com.openexchange.file.storage.numberOfPregeneratedPreviews 20 /opt/open-xchange/etc/filestorage.properties

    # SoftwareChange_Request-2672
    ox_add_property com.openexchange.connector.shutdownFast false /opt/open-xchange/etc/server.properties
    ox_add_property com.openexchange.connector.awaitShutDownSeconds 90 /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-2698
    ox_add_property com.openexchange.mail.rateLimitDisabledRange "" /opt/open-xchange/etc/mail.properties

    # SoftwareChange_Request-2772
    ox_add_property com.openexchange.ajax.response.includeArguments false /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-2815
    ox_add_property html.tag.s '""' /opt/open-xchange/etc/whitelist.properties

    # SoftwareChange_Request-2821
    ox_add_property com.openexchange.mail.autoconfig.http.proxy "" /opt/open-xchange/etc/autoconfig.properties
    ox_add_property com.openexchange.mail.autoconfig.http.proxy.login "" /opt/open-xchange/etc/autoconfig.properties
    ox_add_property com.openexchange.mail.autoconfig.http.proxy.password "" /opt/open-xchange/etc/autoconfig.properties
    ox_add_property com.openexchange.mail.autoconfig.allowGuess true /opt/open-xchange/etc/autoconfig.properties

    # SoftwareChange_Request-2831
    ox_add_property com.openexchange.tools.images.transformations.maxSize 5242880 /opt/open-xchange/etc/server.properties
    ox_add_property com.openexchange.tools.images.transformations.maxResolution 12087962 /opt/open-xchange/etc/server.properties
    ox_add_property com.openexchange.tools.images.transformations.waitTimeoutSeconds 10 /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-2849
    PFILE=/opt/open-xchange/etc/permissions.properties
    if ! ox_exists_property com.openexchange.capability.archive_emails $PFILE; then
        ox_set_property com.openexchange.capability.archive_emails true $PFILE
    fi

    # SoftwareChange_Request-2990
    ox_add_property com.openexchange.hazelcast.healthMonitorLevel silent /opt/open-xchange/etc/hazelcast.properties

    # SoftwareChange_Request-2993
    ox_add_property com.openexchange.contact.fulltextAutocomplete false /opt/open-xchange/etc/contact.properties
    ox_add_property com.openexchange.contact.fulltextIndexFields "DISPLAY_NAME, SUR_NAME, GIVEN_NAME, TITLE, SUFFIX, MIDDLE_NAME, COMPANY, EMAIL1, EMAIL2, EMAIL3" /opt/open-xchange/etc/contact.properties

    # SoftwareChange_Request-3000
    ox_add_property com.openexchange.contact.autocomplete.fields "GIVEN_NAME, SUR_NAME, DISPLAY_NAME, EMAIL1, EMAIL2, EMAIL3" /opt/open-xchange/etc/contact.properties
    ox_add_property com.openexchange.contact.search.fields "ADDRESS_FIELDS, EMAIL_FIELDS, NAME_FIELDS, PHONE_FIELDS, CATEGORIES, COMPANY, DEPARTMENT, COMMERCIAL_REGISTER, POSITION" /opt/open-xchange/etc/contact.properties

    # SoftwareChange_Request-3034
    ox_add_property com.openexchange.mail.bodyDisplaySizeLimit 10485760 /opt/open-xchange/etc/mail.properties

    # SoftwareChange_Request-3054
    ox_add_property com.openexchange.mail.forwardUnquoted false /opt/open-xchange/etc/mail.properties

    # SoftwareChange_Request-3113
    TMPFILE=$(mktemp)
    rm -f $TMPFILE
    cat <<EOF | /opt/open-xchange/sbin/xmlModifier -i /opt/open-xchange/etc/logback.xml -o $TMPFILE -x /configuration/logger -d @name -r -
<configuration>
    <logger name="liquibase.ext.logging.slf4j.Slf4jLogger" level="WARN"/>
</configuration>
EOF
    if [ -e $TMPFILE ]; then
      cat $TMPFILE > /opt/open-xchange/etc/logback.xml
      rm -f $TMPFILE
    fi

    # SoftwareChange_Request-3159
    ox_add_property com.openexchange.snippet.quota.limit -1 /opt/open-xchange/etc/snippets.properties

    # SoftwareChange_Request-3219
    ox_remove_property com.openexchange.participant.MaximumNumberParticipants /opt/open-xchange/etc/participant.properties

    # SoftwareChange_Request-3248
    ox_add_property com.openexchange.connector.networkSslListenerPort 8010 /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-3254
    if ox_scr_todo SoftwareChange_Request-3254
    then
        VALUE=$(ox_read_property com.openexchange.mail.account.blacklist /opt/open-xchange/etc/mail.properties)
        if [ "" = "$VALUE" ]; then
            ox_set_property com.openexchange.mail.account.blacklist "127.0.0.1-127.255.255.255,localhost" /opt/open-xchange/etc/mail.properties
        fi
        ox_add_property com.openexchange.mail.account.whitelist.ports "143,993, 25,465,587, 110,995" /opt/open-xchange/etc/mail.properties
        ox_scr_done SoftwareChange_Request-3254
    fi

    # SoftwareChange_Request-3225
    ox_add_property com.openexchange.tools.images.transformations.preferThumbnailThreshold 0.8 /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-3246
    ox_add_property com.openexchange.mail.mailStartTls false /opt/open-xchange/etc/mail.properties
    ox_add_property com.openexchange.mail.transportStartTls false /opt/open-xchange/etc/mail.properties

    # SoftwareChange_Request-3350
    if grep "XX:DisableExplicitGC" >/dev/null /opt/open-xchange/etc/ox-scriptconf.sh; then
      sed -i '/^JAVA_XTRAOPTS=/s/ -XX:+DisableExplicitGC//' /opt/open-xchange/etc/ox-scriptconf.sh
    fi

    # SoftwareChange_Request-3355,3417
    oldlink=$(ox_read_property object_link /opt/open-xchange/etc/notification.properties)
    if [[ ${oldlink} == *"[uiwebpath]#m=[module]&i=[object]&f=[folder]" ]]
    then
      newlink=$(echo ${oldlink} | sed -e 's;^\(.*\)/\[uiwebpath\].*$;\1/[uiwebpath]#!!\&app=io.ox/[module]\&id=[object]\&folder=[folder];')
      ox_set_property object_link ${newlink} /opt/open-xchange/etc/notification.properties
    fi

    # SoftwareChange_Request-3356
    ox_add_property com.openexchange.ajax.login.checkPunyCodeLoginString false /opt/open-xchange/etc/login.properties

    # SoftwareChange_Request-3405
    ox_add_property com.openexchange.ical.updateTimezones true /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-3406
    # search from the named appender up to the next closing pattern or
    # suffixPattern and replace only %message with %sanitisedMessage in that
    # context
    logconfig=/opt/open-xchange/etc/logback.xml
    tmp=${logconfig}.tmp
    cp -a --remove-destination $logconfig $tmp
    sed -r -i '/<appender .*name="FILE".*>/,/<\/pattern>/ s/%message/%sanitisedMessage/g' $tmp
    sed -r -i '/<appender .*name="FILE_COMPAT".*>/,/<\/pattern>/ s/%message/%sanitisedMessage/g' $tmp
    sed -r -i '/<appender .*name="SYSLOG".*>/,/<\/suffixPattern>/ s/%message/%sanitisedMessage/g' $tmp
    if [[ $(ox_md5 $tmp) != $(ox_md5 $logconfig) ]]; then
      cat $tmp >$logconfig
    else
      rm $tmp
    fi

    # SoftwareChange_Request-3421
    ox_remove_property com.openexchange.mail.transport.enablePublishOnExceededQuota /opt/open-xchange/etc/transport.properties
    ox_remove_property com.openexchange.mail.transport.publishPrimaryAccountOnly /opt/open-xchange/etc/transport.properties
    ox_remove_property com.openexchange.mail.transport.sendAttachmentToExternalRecipients /opt/open-xchange/etc/transport.properties
    ox_remove_property com.openexchange.mail.transport.provideLinksInAttachment /opt/open-xchange/etc/transport.properties
    ox_remove_property com.openexchange.mail.transport.publishedDocumentTimeToLive /opt/open-xchange/etc/transport.properties
    ox_remove_property com.openexchange.mail.transport.externalRecipientsLocale /opt/open-xchange/etc/transport.properties

    # SoftwareChange_Request-3482
    ox_add_property com.openexchange.secret.recovery.fast.enabled true /opt/open-xchange/etc/secret.properties

    # SoftwareChange_Request-3528
    ox_add_property html.tag.code '""' /opt/open-xchange/etc/whitelist.properties

    # Bug #45347
    old_key=io.ox.calendar//participantBlacklist
    new_key=io.ox/calendar//participantBlacklist
    propfile=/opt/open-xchange/etc/settings/participant-blacklist.properties

    if ! ox_exists_property ${new_key} ${propfile}
    then
        if ox_exists_property ${old_key} ${propfile}
        then
            value=$(ox_read_property ${old_key} ${propfile})
            ox_remove_property ${old_key} ${propfile}
            ox_add_property ${new_key} "${value}" ${propfile}
        else
            ox_comment ${old_key} remove ${propfile}
            ox_remove_property ${old_key} ${propfile}
            ox_add_property ${new_key} "" ${propfile}
        fi
    fi

    # SoftwareChange_Request-3616
    ox_add_property com.openexchange.mail.compose.share.preview.timeout 1000 /opt/open-xchange/etc/mail-compose.properties

    # SoftwareChange_Request-3637
    VALUE=$(ox_read_property com.openexchange.connector.maxRequestParameters /opt/open-xchange/etc/server.properties)
    if [ "30" = "$VALUE" ]; then
        ox_set_property com.openexchange.connector.maxRequestParameters 1000 /opt/open-xchange/etc/server.properties
    fi

    # SoftwareChange_Request-3773
    if grep '^# Maximum number of open Files for the groupware$' >/dev/null /opt/open-xchange/etc/ox-scriptconf.sh; then
      sed -i '/^# Maximum number of open Files for the groupware$/{i\
# Maximum number of open Files for the groupware. This value will only be\
# applied when using sysv init. For systemd have a look at the drop-in configs\
# at /etc/systemd/system/open-xchange.service.d
d
}' /opt/open-xchange/etc/ox-scriptconf.sh
    fi

    # SoftwareChange_Request-3784
    VALUE=$(ox_read_property com.openexchange.IPCheckWhitelist /opt/open-xchange/etc/server.properties)
    if [ "\"open-xchange-mailapp\"" = "$VALUE" ]; then
        ox_set_property com.openexchange.IPCheckWhitelist "\"open-xchange-mailapp\", \"open-xchange-mobile-api-facade\"" /opt/open-xchange/etc/server.properties
    fi

    # SoftwareChange_Request-3859
    VALUE=$(ox_read_property NRFILES /opt/open-xchange/etc/ox-scriptconf.sh)
    VALUE=${VALUE//\"/}
    if [ "8192" = "$VALUE" ]; then
        ox_set_property NRFILES 65536 /opt/open-xchange/etc/ox-scriptconf.sh
    fi

    # SoftwareChange_Request-3862
    if ! grep -Eq "^#\s?html.tag.form" >/dev/null /opt/open-xchange/etc/whitelist.properties; then
      ox_comment html.tag.form add /opt/open-xchange/etc/whitelist.properties
    fi
    if ! grep -Eq "^#\s?html.tag.input" >/dev/null /opt/open-xchange/etc/whitelist.properties; then
      ox_comment html.tag.input add /opt/open-xchange/etc/whitelist.properties
    fi

    # SoftwareChange_Request-3882
    ox_add_property NPROC 65536 /opt/open-xchange/etc/ox-scriptconf.sh

    # SoftwareChange_Request-3934
    if ! grep -Eq "^#\s?html.style.list-style-image" >/dev/null /opt/open-xchange/etc/whitelist.properties; then
      ox_comment html.style.list-style-image add /opt/open-xchange/etc/whitelist.properties
    fi

    # SoftwareChange_Request-4033
    TMPFILE=$(mktemp)
    rm -f $TMPFILE
    cat <<EOF | /opt/open-xchange/sbin/xmlModifier -i /opt/open-xchange/etc/logback.xml -o $TMPFILE -x /configuration/logger -d @name -m -
<configuration>
    <logger name="com.hazelcast.internal.monitors" level="INFO"/>
</configuration>
EOF
    if [ -e $TMPFILE ]; then
      cat $TMPFILE > /opt/open-xchange/etc/logback.xml
      rm -f $TMPFILE
    fi

    # SoftwareChange_Request-4059
    ox_remove_property com.openexchange.mail.enforceSecureConnection /opt/open-xchange/etc/mail.properties

    # SoftwareChange_Request-4094
    VALUE=$(ox_read_property com.openexchange.mail.autoconfig.ispdb /opt/open-xchange/etc/autoconfig.properties)
    if [ "https://live.mozillamessaging.com/autoconfig/v1.1/" = "$VALUE" ]; then
        ox_set_property com.openexchange.mail.autoconfig.ispdb "https://autoconfig.thunderbird.net/v1.1/" /opt/open-xchange/etc/autoconfig.properties
    fi

    # SoftwareChange_Request-4096
    # use subshell to not pollute current env when sourcing ox-scriptconf.sh
    (
      . /opt/open-xchange/lib/oxfunctions.sh
      to_migrate=/opt/open-xchange/etc/ox-scriptconf.sh

      # Pitfall_1 JAVA_XTRAOPTS="${JAVA_XTRAOPTS} foo=bar"
      # was added by some customers to ox-scriptconf.sh
      unset JAVA_XTRAOPTS
      . ${to_migrate}
      opts_old=${JAVA_XTRAOPTS}

      # only migrate if pre RM-177 style options are found
      if [[ ! -z "${opts_old}" ]]
      then
        backup=${to_migrate}.$(date +%s)
        cp -a --remove-destination ${to_migrate} ${backup}

        gc_regx="-XX:\+UseConcMarkSweepGC|-XX:\+UseParNewGC|-XX:CMSInitiatingOccupancyFraction|-XX:\+UseCMSInitiatingOccupancyOnly|-XX:NewRatio|-XX:\+DisableExplicitGC"
        log_regx="-Dlogback.threadlocal.put.duplicate|-XX:-OmitStackTraceInFastThrow"
        mem_regx="-Xmx|-XX:MaxHeapSize|-XX:MaxPermSize|-XX:\+UseTLAB"
        net_regx="-Dsun.net.inetaddr.ttl|-Dnetworkaddress.cache.ttl|-Dnetworkaddress.cache.negative.ttl"
        osgi_regx="-Dosgi.compatibility.bootdelegation"
        server_regx="-server|-Djava.awt.headless"

        opts_gc=()
        opts_log=()
        opts_mem=()
        opts_net=()
        opts_osgi=()
        opts_server=()
        opts_other=()

        ((debug)) && echo "The options are: ${opts_old}"

        opt_arr=(${opts_old})
        num_opts=${#opt_arr[@]}
        ((debug)) && echo "There are ${num_opts} options to migrate"
        for ((i=0; i < num_opts; i++))
        do
          #assign single options to appropriate array
          ((debug)) && echo "Option ${i}: ${opt_arr[${i}]}"
          curr_opt=${opt_arr[${i}]}
          if [[ "${curr_opt}" =~ ${gc_regx} ]]
          then
            ((debug)) && echo "${curr_opt} is a gc opt"
            opts_gc+=(${curr_opt})
          elif [[ "${curr_opt}" =~ ${log_regx} ]]
          then
            ((debug)) && echo "${curr_opt} is a log opt"
            opts_log+=(${curr_opt})
          elif [[ "${curr_opt}" =~ ${mem_regx} ]]
          then
            ((debug)) && echo "${curr_opt} is a mem opt"
            opts_mem+=(${curr_opt})
          elif [[ "${curr_opt}" =~ ${net_regx} ]]
          then
            ((debug)) && echo "${curr_opt} is a net opt"
            opts_net+=(${curr_opt})
          elif [[ "${curr_opt}" =~ ${osgi_regx} ]]
          then
            ((debug)) && echo "${curr_opt} is an osgi opt"
            opts_osgi+=(${curr_opt})
          elif [[ "${curr_opt}" =~ ${server_regx} ]]
          then
            ((debug)) && echo "${curr_opt} is a server opt"
            opts_server+=(${curr_opt})
          else
            ((debug)) && echo "${curr_opt} is another opt"
            opts_other+=(${curr_opt})
          fi
        done

        ox_add_property JAVA_OPTS_GC     "\"${opts_gc[*]}\""     "${to_migrate}"
        ox_add_property JAVA_OPTS_LOG    "\"${opts_log[*]}\""    "${to_migrate}"
        ox_add_property JAVA_OPTS_MEM    "\"${opts_mem[*]}\""    "${to_migrate}"
        ox_add_property JAVA_OPTS_NET    "\"${opts_net[*]}\""    "${to_migrate}"
        ox_add_property JAVA_OPTS_OSGI   "\"${opts_osgi[*]}\""   "${to_migrate}"
        ox_add_property JAVA_OPTS_SERVER "\"${opts_server[*]}\"" "${to_migrate}"
        ox_add_property JAVA_OPTS_OTHER  "\"${opts_other[*]}\""  "${to_migrate}"
        sed -i -e '${a\
    # Define options for debugging the groupware Java virtual machine, disabled by default.\
    #JAVA_OPTS_DEBUG="-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/mnt/heapdump -Xloggc:/var/log/open-xchange/gc.log -verbose:gc -XX:+PrintGCDateStamps -XX:+PrintHeapAtGC -XX:+PrintGCApplicationStoppedTime -XX:+PrintTenuringDistribution"
        }' "${to_migrate}"

        # Pitfall_1: removes all occurrences
        ox_remove_property JAVA_XTRAOPTS "${to_migrate}"
      fi
    )

    # SoftwareChange_Request-4098
    ox_remove_property com.openexchange.mail.attachmentDisplaySizeLimit /opt/open-xchange/etc/mail.properties

    # SoftwareChange_Request-4149
    ox_set_property marital_status 'Marital status' /opt/open-xchange/importCSV/open-xchange.properties
    if [ "Number of employee" == "$(ox_read_property employee_type /opt/open-xchange/importCSV/open-xchange.properties)" ]; then
      sed -i 's/employee_type=Number of employee/number_of_employees=Employee ID/g' /opt/open-xchange/importCSV/open-xchange.properties
    fi

    # SoftwareChange_Request-4204
    pfile=/opt/open-xchange/etc/whitelist.properties
    for property in html.style.page-break-{after,before,inside}
    do
      ox_remove_property ${property} ${pfile}
    done

    # SoftwareChange_Request-4249
    set -e
    TMPFILE=$(mktemp)
    rm -f $TMPFILE
    /opt/open-xchange/sbin/xmlModifier -i /opt/open-xchange/etc/logback.xml -s 4249 -o $TMPFILE
    if [ -e $TMPFILE ]; then
      cat $TMPFILE > /opt/open-xchange/etc/logback.xml
      rm -f $TMPFILE
    fi
    set +e

    # SoftwareChange_Request-66
    ox_remove_property com.openexchange.hazelcast.jmxDetailed /opt/open-xchange/etc/hazelcast.properties

    # SoftwareChange_Request-77
    PFILE=/opt/open-xchange/etc/cache.ccf
    NAMES=( jcs.region.User.cacheattributes.MaxObjects jcs.region.UserConfiguration.cacheattributes.MaxObjects jcs.region.UserPermissionBits.cacheattributes.MaxObjects jcs.region.UserSettingMail.cacheattributes.MaxObjects jcs.region.Context.cacheattributes.MaxObjects )
    OLDDEFAULTS=( 40000 20000 20000 20000 10000 )
    NEWDEFAULTS=( 4000000 4000000 4000000 4000000 1000000 )
    for I in $(seq 1 ${#NAMES[@]}); do
      VALUE=$(ox_read_property ${NAMES[$I-1]} $PFILE)
      if [ "${VALUE}" = "${OLDDEFAULTS[$I-1]}" ]; then
        ox_set_property ${NAMES[$I-1]} "${NEWDEFAULTS[$I-1]}" $PFILE
      fi
    done

    # SoftwareChange_Request-82
    ox_remove_property com.openexchange.caching.jcs.enabled /opt/open-xchange/etc/cache.properties

    # SoftwareChange_Request-151
    VALUE=$(ox_read_property com.openexchange.push.allowedClients /opt/open-xchange/etc/mail-push.properties)
    if [ "\"USM-EAS*\", \"USM-JSON*\", \"open-xchange-mailapp\"" = "${VALUE}" ]; then
        ox_set_property com.openexchange.push.allowedClients "${VALUE}, \"open-xchange-mobile-api-facade*\"" /opt/open-xchange/etc/mail-push.properties
    fi

    # SoftwareChange_Request-160
    whlipr=/opt/open-xchange/etc/whitelist.properties
    ox_add_property html.style.webkit-box-sizing '""' ${whlipr}
    ox_add_property html.style.moz-box-sizing '""' ${whlipr}
    ox_add_property html.style.box-sizing '"border-box"' ${whlipr}
    ox_add_property html.style.-webkit-box-sizing '"border-box"' ${whlipr}
    ox_add_property html.style.-moz-box-sizing '"border-box"' ${whlipr}

    # SoftwareChange_Request-174
    ox_remove_property IGNORE_SHARED_ADDRESSBOOK /opt/open-xchange/etc/foldercache.properties

    # SoftwareChange_Request-175
    ox_add_property com.openexchange.server.migrationRedirectURL "" /opt/open-xchange/etc/server.properties

    # SoftwareChange_Request-193
    VALUE=$(ox_read_property com.openexchange.push.allowedClients /opt/open-xchange/etc/mail-push.properties)
    if [ "\"USM-EAS*\", \"USM-JSON*\", \"open-xchange-mailapp\", \"open-xchange-mobile-api-facade*\"" = "${VALUE}" ]; then
        ox_set_property com.openexchange.push.allowedClients "\"USM-EAS*\", \"open-xchange-mobile-api-facade*\"" /opt/open-xchange/etc/mail-push.properties
    fi

    SCR=SCR-208
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/etc/configdb.properties

      declare -A dmap
      dmap[3]="useUnicode=true"
      dmap[4]="characterEncoding=UTF-8"
      dmap[5]="autoReconnect=false"
      dmap[6]="useServerPrepStmts=false"
      dmap[7]="useTimezone=true"
      dmap[8]="serverTimezone=UTC"
      dmap[9]="connectTimeout=15000"
      dmap[10]="socketTimeout=15000"

      for x in {3..10}
      do
        default_val=${dmap[$x]}
        for prop_type in readProperty writeProperty
        do
          prop=${prop_type}.${x}
          curr_val=$(ox_read_property ${prop} ${pfile})
          if [ -n "${curr_val}" ]
          then
            if [ "${default_val}" == "${curr_val}" ]
            then
              ox_remove_property ${prop} ${pfile}
            fi
          fi
        done
      done
      ox_scr_done ${SCR}
    }

    # SoftwareChange_Request-236
    PFILE=/opt/open-xchange/etc/cache.ccf
    NAMES=( jcs.region.CalendarCache jcs.region.CalendarCache.cacheattributes jcs.region.CalendarCache.cacheattributes.MaxObjects jcs.region.CalendarCache.cacheattributes.MemoryCacheName jcs.region.CalendarCache.cacheattributes.UseMemoryShrinker jcs.region.CalendarCache.cacheattributes.MaxMemoryIdleTimeSeconds jcs.region.CalendarCache.cacheattributes.ShrinkerIntervalSeconds jcs.region.CalendarCache.cacheattributes.MaxSpoolPerRun jcs.region.CalendarCache.elementattributes jcs.region.CalendarCache.elementattributes.IsEternal jcs.region.CalendarCache.elementattributes.MaxLifeSeconds jcs.region.CalendarCache.elementattributes.IdleTime jcs.region.CalendarCache.elementattributes.IsSpool jcs.region.CalendarCache.elementattributes.IsRemote jcs.region.CalendarCache.elementattributes.IsLateral )
    for I in $(seq 1 ${#NAMES[@]}); do
      ox_remove_property ${NAMES[$I-1]} $PFILE
    done

    # SoftwareChange_Request-240
    pfile=/opt/open-xchange/etc/contact.properties
    image_k=com.openexchange.contact.scaleVCardImages
    width_k=com.openexchange.contact.image.maxWidth
    height_k=com.openexchange.contact.image.maxHeight
    image_v=$(ox_read_property ${image_k} ${pfile})
    width_v=$(ox_read_property ${width_k} ${pfile})
    height_v=$(ox_read_property ${height_k} ${pfile})
    if [ "200x200" == "${image_v}" ] && [ "250" == "${width_v}" ] && [ "250" == "${height_v}" ]
    then
      ox_set_property ${image_k} "600x800" ${pfile}
      ox_set_property ${width_k} "600" ${pfile}
      ox_set_property ${height_k} "800" ${pfile}
    fi

    # SoftwareChange_Request-287
    pfile=/opt/open-xchange/etc/contact.properties
    scale_k=com.openexchange.contact.image.scaleType
    scale_v=$(ox_read_property ${scale_k} ${pfile})
    if [ -n "${scale_v}" ]
    then
      if [ "2" == "${scale_v}" ]
      then
        ox_set_property ${scale_k} "1" ${pfile}
      else
        ox_set_property ${scale_k} ${scale_v} ${pfile}
      fi
    fi

    SCR=SCR-299
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/etc/cache.ccf
      for region in OXFolderCache OXFolderQueryCache GlobalFolderCache
      do
        curr_val=$(ox_read_property jcs.region.${region}.elementattributes.MaxLifeSeconds ${pfile})
        if [ "-1" = "${curr_val}" ]
        then
          ox_set_property jcs.region.${region}.elementattributes.MaxLifeSeconds 3600 ${pfile}
        fi
      done
      ox_scr_done ${SCR}
    }

    SCR=SCR-322.core
    ox_scr_todo ${SCR} && {
      prop_file=/opt/open-xchange/etc/server.properties
      prop_key=PUBLISH_REVOKE
      if ox_exists_property ${prop_key} ${prop_file}
      then
        prop_val=$(ox_read_property ${prop_key} ${prop_file})
        if [ -z "${prop_val}" ]
        then
          ox_remove_property ${prop_key} ${prop_file} 
        fi
      fi
      ox_scr_done ${SCR}
    }

    SCR=SCR-391
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/etc/mime.types
      type="video/x-matroska mkv"
      if ! contains "${type}" ${pfile}
      then
        echo "${type}" >> ${pfile}
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      ox_scr_done ${SCR}
    }

    SCR=SCR-422
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/etc/mime.types
      type="image/heic heic"
      if ! contains "${type}" ${pfile}
      then
        echo "${type}" >> ${pfile}
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      type="image/heif heif"
      if ! contains "${type}" ${pfile}
      then
        echo "${type}" >> ${pfile}
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      ox_scr_done ${SCR}
    }

    # SCR-426
    if ! contains "Allow users to configure the showContactImage setting" /opt/open-xchange/etc/settings/ui.properties; then
        cat <<EOF | (cd /opt/open-xchange/etc && patch --strip=3 --forward --no-backup-if-mismatch --reject-file=- --fuzz=3 >/dev/null)
diff --git a/com.openexchange.groupware.settings.extensions/conf/settings/ui.properties b/com.openexchange.groupware.settings.extensions/conf/settings/ui.properties
index 3ce3af8146f..61ee86367b8 100644
--- a/com.openexchange.groupware.settings.extensions/conf/settings/ui.properties
+++ b/com.openexchange.groupware.settings.extensions/conf/settings/ui.properties
@@ -2,7 +2,7 @@
 # Possible values: embedded and popups
 ui/global/windows/mode/value=embedded

-# All user to configure the latter
+# Allow users to configure the windows mode
 # Possible values: true|false
 ui/global/windows/mode/configurable=true

@@ -10,7 +10,7 @@ ui/global/windows/mode/configurable=true
 # Possible values: tabbased|simple
 ui/global/toolbar/mode/value=tabbased

-# All user to configure the latter
+# Allow users to configure the toolbar mode
 # Possible values: true|false
 ui/global/toolbar/mode/configurable=true

@@ -18,7 +18,7 @@ ui/global/toolbar/mode/configurable=true
 # Possible values: true|false
 ui/mail/showContactImage/value = true

-# All user to configure the latter
+# Allow users to configure the showContactImage setting
 # Possible values: true|false
 # Please configure the ui.yml accordingly.
 ui/mail/showContactImage/configurable = true
EOF
    fi

    # SCR-470
    if ! contains "onmouseleave" /opt/open-xchange/etc/globaleventhandlers.list; then
      sed -i "s/onmounseleave/onmouseleave/" /opt/open-xchange/etc/globaleventhandlers.list
  fi

  SCR=SCR-480
  ox_scr_todo ${SCR} && {
    set -e
    TMPFILE=$(mktemp)
    rm -f $TMPFILE
    /opt/open-xchange/sbin/xmlModifier -i /opt/open-xchange/etc/logback.xml -s 480 -o $TMPFILE
    if [ -e $TMPFILE ]; then
      cat $TMPFILE > /opt/open-xchange/etc/logback.xml
      rm -f $TMPFILE
    fi
    set +e
    ox_scr_done ${SCR}
  }

  SCR=SCR-481
  ox_scr_todo ${SCR} && {
    pfile=/opt/open-xchange/etc/hazelcast.properties
    pkey=com.openexchange.hazelcast.group.password
    comment="# - ${pkey}"

    if contains "${comment}" ${pfile}
    then
      sed -i -e "/^# If this is a single-node installation/,/^# - com.openexchange.hazelcast.network.interfaces/{
        /${comment}/d
      }" ${pfile}
    fi

    ox_remove_property ${pkey} ${pfile}
    ox_scr_done ${SCR}
  }

    SCR=SCR-489
    ox_scr_todo ${SCR} && {
      pfile_sessiond=/opt/open-xchange/etc/sessiond.properties
      pkey_sessiond=com.openexchange.sessiond.autologin
      pfile_share=/opt/open-xchange/etc/share.properties
      pkey_share=com.openexchange.share.autoLogin

      ox_remove_property ${pkey_sessiond} ${pfile_sessiond}
      ox_remove_property ${pkey_share} ${pfile_share}

      ox_scr_done ${SCR}
    }

    SCR=SCR-502
    ox_scr_todo ${SCR} && {
      scriptconf=/opt/open-xchange/etc/ox-scriptconf.sh
      contains JAVA_OPTS_SECURITY= ${scriptconf}  || {
        sed -i -e '/^JAVA_OPTS_SERVER=.*$/a #JAVA_OPTS_SECURITY="-Dorg.osgi.framework.security=osgi -Djava.security.policy=/opt/open-xchange/etc/all.policy -Dopenexchange.security.policy=/opt/open-xchange/etc/security/policies.policy -Duser.dir=/opt/open-xchange/bundles -Djna.platform.library.path=/usr/lib/x86_64-linux-gnu:/usr/lib64"' ${scriptconf}
      }
      ox_scr_done ${SCR}
    }

    # obsoletes SoftwareChange_Request-2665
    SCR=SCR-548
    ox_scr_todo ${SCR} && {
      pfile=/opt/open-xchange/etc/notification.properties

      ox_remove_property imipForInternalUsers ${pfile}
      ox_remove_property notify_participants_on_delete ${pfile}
      ox_remove_property com.openexchange.calendar.notify.poolenabled ${pfile}

      ox_scr_done ${SCR}
    }

    # SCR-522
    if ! contains "of other nodes via multicast) or \"dns\" to consult a DNS server to resolve the" /opt/open-xchange/etc/hazelcast.properties; then
      cat <<EOF | (cd /opt/open-xchange/etc && patch --strip=1 --forward --no-backup-if-mismatch --reject-file=- --fuzz=3 >/dev/null)
diff --git a/hazelcast.properties b/hazelcast.properties
index d56a04f3e1f..1214fd369fe 100644
--- a/hazelcast.properties
+++ b/hazelcast.properties
@@ -44,10 +44,11 @@ com.openexchange.hazelcast.group.name=
 
 # Specifies which mechanism is used to discover other backend nodes in the
 # cluster. Possible values are "empty" (no discovery for single-node setups),
-# "static" (fixed set of cluster member nodes) or "multicast" (automatic
-# discovery of other nodes via multicast). Defaults to "empty". Depending on
-# the specified value, further configuration might be needed, see "Networking"
-# section below.
+# "static" (fixed set of cluster member nodes), "multicast" (automatic discovery
+# of other nodes via multicast) or "dns" to consult a DNS server to resolve the
+# domain names to the most recent set of IP addresses of all service nodes.
+# Defaults to "empty". Depending on the specified value, further configuration
+# might be needed; see "Networking" section below.
 com.openexchange.hazelcast.network.join=empty
 
 # Configures a comma-separated list of IP addresses / hostnames of possible
EOF
    fi
    ox_add_property com.openexchange.hazelcast.network.join.dns.domainNames "" /opt/open-xchange/etc/hazelcast.properties

    SCR=SCR-698
    if ox_scr_todo ${SCR}
    then
        PFILE=/opt/open-xchange/etc/cache.ccf
        if ! grep "jcs.region.Group=LTCP" > /dev/null $PFILE; then
            echo -e "\n# Pre-defined cache region for Group data" >> $PFILE
            echo "jcs.region.Group=LTCP" >> $PFILE
            echo "jcs.region.Group.cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes" >> $PFILE
            echo "jcs.region.Group.cacheattributes.MaxObjects=4000000" >> $PFILE
            echo "jcs.region.Group.cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache" >> $PFILE
            echo "jcs.region.Group.cacheattributes.UseMemoryShrinker=true" >> $PFILE
            echo "jcs.region.Group.cacheattributes.MaxMemoryIdleTimeSeconds=360" >> $PFILE
            echo "jcs.region.Group.cacheattributes.ShrinkerIntervalSeconds=60" >> $PFILE
            echo "jcs.region.Group.cacheattributes.MaxSpoolPerRun=500" >> $PFILE
            echo "jcs.region.Group.elementattributes=org.apache.jcs.engine.ElementAttributes" >> $PFILE
            echo "jcs.region.Group.elementattributes.IsEternal=false" >> $PFILE
            echo "jcs.region.Group.elementattributes.MaxLifeSeconds=-1" >> $PFILE
            echo "jcs.region.Group.elementattributes.IdleTime=360" >> $PFILE
            echo "jcs.region.Group.elementattributes.IsSpool=false" >> $PFILE
            echo "jcs.region.Group.elementattributes.IsRemote=false" >> $PFILE
            echo -e "jcs.region.Group.elementattributes.IsLateral=false\n" >> $PFILE
        fi
        ox_scr_done ${SCR}
    fi

    if ox_scr_todo SCR-713
    then
        ox_remove_property ui/portal/customUWA /opt/open-xchange/etc/settings/ui.properties
        ox_scr_done SCR-713
    fi

    if ox_scr_todo SCR-676-mw
    then
        # rename all appenders, converters, encoders and policies classes
        logconfig=/opt/open-xchange/etc/logback.xml
        tmp=${logconfig}.tmp
        cp -a --remove-destination $logconfig $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.LogstashSocketAppender/com.openexchange.logback.extensions.appenders.logstash.LogstashAppender/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.encoder/com.openexchange.logback.extensions.appenders.logstash.encoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.queueSize/com.openexchange.logback.extensions.appenders.logstash.queueSize/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.alwaysPersistEvents/com.openexchange.logback.extensions.appenders.logstash.alwaysPersistEvents/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.loadFactor/com.openexchange.logback.extensions.appenders.logstash.loadFactor/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.connectionTimeout/com.openexchange.logback.extensions.appenders.logstash.connectionTimeout/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.mbeanEnabled/com.openexchange.logback.extensions.appenders.logstash.mbeanEnabled/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.CustomFieldsAction/com.openexchange.logback.extensions.encoders.CustomFieldAction/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.logstash\.CustomField/com.openexchange.logback.extensions.encoders.CustomField/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ExtendedPatternLayoutEncoder/com.openexchange.logback.extensions.encoders.ExtendedPatternLayoutEncoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.JSONEncoder/com.openexchange.logback.extensions.encoders.JSONEncoder/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.SyslogPatternLayoutActivator/com.openexchange.logback.extensions.encoders.SyslogPatternLayoutActivator/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ExtendedReplacingCompositeConverter/com.openexchange.logback.extensions.converters.ExtendedReplacingCompositeConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.LineMDCConverter/com.openexchange.logback.extensions.converters.LineMDCConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.LogSanitisingConverter/com.openexchange.logback.extensions.converters.LogSanitisingConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.ThreadIdConverter/com.openexchange.logback.extensions.converters.ThreadIdConverter/g' $tmp
        sed -i 's/com\.openexchange\.logback\.extensions\.FixedWindowRollingPolicy/com.openexchange.logback.extensions.policies.FixedWindowRollingPolicy/g' $tmp
        if [[ $(ox_md5 $tmp) != $(ox_md5 $logconfig) ]]; then
            cat $tmp >$logconfig
        fi
        rm $tmp
        ox_scr_done SCR-676-mw
    fi

    SCR=SCR-740
    if ox_scr_todo ${SCR}
    then
      prop_file=/opt/open-xchange/etc/system.properties
      prop_key=com.openexchange.config.cascade.scopes
      old_default_value="user, context, contextSets, server"
      new_default_value="user, context, reseller, contextSets, server"
      if ox_exists_property ${prop_key} ${prop_file}
      then
        prop_val=$(ox_read_property ${prop_key} ${prop_file})
        if [ "${old_default_value}" = "${prop_val}" ]
        then
          ox_set_property ${prop_key} "${new_default_value}" ${prop_file}
        fi
      fi
      ox_scr_done ${SCR}
    fi

    SCR=SCR-758
    if ox_scr_todo ${SCR}
    then
      unset GLOBIGNORE
      props="com.openexchange.capabilities.allowIllegalPermissionProvisioning com.openexchange.capabilities.applyIllegalPermissions"
      for prop in ${props}
      do
        matches="$(grep -Hs "^\s*$prop" /opt/open-xchange/etc/*.properties)"
        if [ $? -eq 0 ]
        then
          IFS=$'\n'
          for match in ${matches}
          do
            unset IFS
            file=${match%%:*}
            if [ -f "${file}" ]
            then
              ox_remove_property ${prop} "${file}"
            fi
          done
        fi
      done
      ox_scr_done ${SCR}
    fi
    GLOBIGNORE='*'

    SCR=SCR-810
    if ox_scr_todo ${SCR}
    then
      prop_file=/opt/open-xchange/etc/ox-scriptconf.sh
      old_default_value='JAVA_OPTS_GC="-XX:+UseConcMarkSweepGC -XX:+UseParNewGC -XX:CMSInitiatingOccupancyFraction=75 -XX:+UseCMSInitiatingOccupancyOnly -XX:NewRatio=3"'
      new_default_value='JAVA_OPTS_GC="-XX:+UseConcMarkSweepGC -XX:+UseParNewGC -XX:CMSInitiatingOccupancyFraction=75 -XX:+UseCMSInitiatingOccupancyOnly"'
      IFS=$'\n'
      findings=( $(grep '^JAVA_OPTS_GC=' ${prop_file}) )
      unset IFS
      if [ 1 -eq ${#findings[@]} ] && [ "${old_default_value}"  = "${findings[0]}" ]
      then
        sed -i -e "s/^${old_default_value}\$/${new_default_value}/" $prop_file
      fi
      ox_scr_done ${SCR}
    fi

    SCR=SCR-842
    if ox_scr_todo ${SCR}
    then
      pfile=/opt/open-xchange/etc/mime.types
      type="image/xcf xcf"
      if ! contains "${type}" ${pfile}
      then
        echo "${type}" >> ${pfile}
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      type="image/x-xcf xcf"
      if ! contains "${type}" ${pfile}
      then
        echo "${type}" >> ${pfile}
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      ox_scr_done ${SCR}
    fi

    SCR=SCR-882
    if ox_scr_todo ${SCR}
    then
      pfile=/opt/open-xchange/etc/mime.types
      changed=false
      for type in "application/vnd.apple.keynote key" \
        "application/vnd.apple.mpegurl m3u8 m3u" \
        "application/vnd.apple.numbers numbers" \
        "application/vnd.apple.pages pages"
      do
        if ! contains "${type}" ${pfile}
        then
          echo "${type}" >> ${pfile}
          changed="true"
        fi
      done
      if [ "${changed}" == "true" ]
      then
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      ox_scr_done ${SCR}
    fi

    SCR=SCR-937
    if ox_scr_todo ${SCR}
    then
      pfile=/opt/open-xchange/etc/mime.types
      changed=false
      for type in "image/niff niff nif" \
        "image/x-niff niff nif"
      do
        if ! contains "${type}" ${pfile}
        then
          echo "${type}" >> ${pfile}
          changed="true"
        fi
      done
      if [ "${changed}" == "true" ]
      then
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      ox_scr_done ${SCR}
    fi

    SCR=SCR-979
    if ox_scr_todo ${SCR}
    then
      pfile=/opt/open-xchange/etc/server.properties
      pkey=com.openexchange.servlet.maxRateLenientClients
      old_default='"Open-Xchange .NET HTTP Client*", "Open-Xchange USM HTTP Client*", "Jakarta Commons-HttpClient*"'
      new_default='"Open-Xchange .NET HTTP Client*", "Open-Xchange USM HTTP Client*", "Jakarta Commons-HttpClient*","OX Drive*", "OX%20Drive*", "OpenXchange.Android.Drive*", "OpenXchange.iOS.Drive*", "DriveFileProvider*"'
      curr_value=$(ox_read_property $pkey $pfile)
      if [ "${curr_value}" == "${old_default}" ]
      then
        ox_set_property ${pkey} "${new_default}" ${pfile}
      fi
      ox_scr_done ${SCR}
    fi

    SCR=SCR-1045
    if ox_scr_todo ${SCR}
    then
      pfile=/opt/open-xchange/etc/mime.types
      changed=false
      for type in "image/x-freehand fh4 fh5 fhc" "image/x-windowdump xwd" "image/x-xbitmap xbm" "image/x-xpixmap xpm"
      do
        if ! contains "${type}" ${pfile}
        then
          echo "${type}" >> ${pfile}
          changed="true"
        fi
      done
      if [ "${changed}" == "true" ]
      then
        LC_COLLATE=C sort -o ${pfile} ${pfile}
      fi
      ox_scr_done ${SCR}
    fi

fi

PROTECT=( autoconfig.properties configdb.properties hazelcast.properties jolokia.properties mail.properties mail-push.properties management.properties secret.properties secrets server.properties sessiond.properties share.properties tokenlogin-secrets )
for FILE in "${PROTECT[@]}"
do
    ox_update_permissions "/opt/open-xchange/etc/$FILE" root:open-xchange 640
done
ox_update_permissions "/opt/open-xchange/etc/ox-scriptconf.sh" root:root 644
ox_update_permissions "/opt/open-xchange/osgi" open-xchange:root 750
ox_update_permissions "/var/spool/open-xchange/uploads" open-xchange:root 750
ox_update_permissions "/var/log/open-xchange" open-xchange:root 750
ox_update_permissions "/opt/open-xchange/sbin/reloadconfiguration" root:open-xchange 740
exit 0

%clean
%{__rm} -rf %{buildroot}

%files -f %{configfiles}
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/documentation
%dir /opt/open-xchange/documentation/etc
/opt/open-xchange/documentation/etc/*.yml
%dir /opt/open-xchange/etc
/opt/open-xchange/etc/all.policy
%dir /opt/open-xchange/etc/contextSets
%dir /opt/open-xchange/etc/meta
%dir /opt/open-xchange/etc/security
/opt/open-xchange/etc/security/*.list
%dir /opt/open-xchange/etc/settings
%dir /opt/open-xchange/i18n/
%dir /opt/open-xchange/importCSV/
%dir /opt/open-xchange/lib/
/opt/open-xchange/lib/*
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*
/opt/open-xchange/osgi/config.ini.template
%dir /opt/open-xchange/sbin/
/opt/open-xchange/sbin/*
%dir /opt/open-xchange/templates/
/opt/open-xchange/templates/*
%dir /opt/open-xchange/etc/hazelcast
%config(noreplace) /opt/open-xchange/etc/hazelcast/*
%dir %attr(750, open-xchange, root) /var/log/open-xchange
%dir /var/spool/open-xchange
%dir %attr(750, open-xchange, root) /var/spool/open-xchange/uploads
%doc docs/
%doc com.openexchange.server/doc/examples
%doc com.openexchange.database/doc/examples
%doc com.openexchange.authentication.application.impl/doc/examples
%doc com.openexchange.ldap.common/doc/examples
%doc properties

%changelog
* Wed Oct 22 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-10-27 (6322)
* Mon Sep 29 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-09-30 (6321)
* Fri Sep 05 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-09-15 (6320)
* Wed Jul 23 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-07-28 (6317)
* Fri Jun 27 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-06-30 (6316)
* Wed Jun 18 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-06-30 (6315)
* Mon May 19 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-05-26 (6313)
* Wed Apr 30 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-05-05 (6312)
* Tue Apr 15 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-04-24
* Tue Mar 04 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-03-24 (6308)
* Wed Feb 19 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-02-24 (6307)
* Thu Jan 23 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-01-27 (6304)
* Tue Jan 07 2025 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2025-01-07
* Tue Dec 10 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2021-12-16 (6303)
* Thu Nov 07 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-11-18 (6300)
* Mon Sep 23 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-10-07 (6298)
* Thu Aug 29 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-09-02 (6295)
* Wed Jul 03 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-07-08 (6292)
* Mon Jun 17 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-06-24 (6286)
* Tue Jun 04 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-05-27 (6280)
* Tue May 21 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-05-23 (6285)
* Wed May 15 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-05-13 (6282)
* Tue Apr 30 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-04-10 (6277)
* Mon Mar 04 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-03-11 (6272)
* Tue Feb 13 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-02-14 (6271)
* Mon Jan 29 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-02-08 (6268)
* Mon Jan 15 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-01-22 (6266)
* Wed Jan 03 2024 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2024-01-04 (6264)
* Sat Dec 02 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-12-11 (6259)
* Tue Nov 14 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-11-20 (6256)
* Mon Oct 23 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-10-30 (6255)
* Thu Sep 28 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-10-09 (6249)
* Fri Sep 22 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-09-22 (6251)
* Mon Sep 18 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-09-18 (6248)
* Tue Aug 08 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-08-28 (6245)
* Tue Jul 18 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-08-01 (6243)
* Wed Jun 28 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-07-11 (6241)
* Thu Jun 15 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-06-26 (6239)
* Fri Jun 09 2023 Marcus Klein <marcus.klein@open-xchange.com>
Manual increment
* Mon Jun 05 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-06-05 (6236)
* Fri May 05 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-05-16 (6235)
* Wed May 03 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-05-02 (6230)
* Tue Apr 11 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-04-10 (6231)
* Fri Mar 31 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-04-05 (6227)
* Mon Mar 06 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-03-20 (6219)
* Wed Feb 15 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-02-27 (6216)
* Tue Feb 07 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-02-08 (6215)
* Thu Jan 26 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-02-06 (6209)
* Thu Jan 19 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-02-01 (6210)
* Tue Jan 03 2023 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2023-01-16 (6204)
* Tue Dec 20 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-12-21 (6205)
* Fri Dec 09 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-12-19 (6199)
* Thu Nov 17 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-11-28 (6194)
* Mon Nov 14 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-11-15 (6195)
* Mon Oct 24 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-11-02 (6189)
* Mon Sep 26 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-10-10 (6178)
* Wed Sep 21 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-09-30 (6179)
* Mon Sep 19 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-09-21 (6176)
* Fri Sep 16 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-09-16 (6175)
* Tue Sep 13 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-09-19 (6173)
* Wed Aug 17 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-08-29 (6166)
* Thu Aug 11 2022 Marcus Klein <marcus.klein@open-xchange.com>
skip revision for preview
* Mon Aug 08 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-08-08 (6156)
* Tue Aug 02 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-08-05 (6163)
* Mon Aug 01 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-08-02 (6161)
* Fri Jul 15 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-07-18 (6150)
* Mon Jul 04 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-07-05 (6148)
* Tue Jun 21 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-06-27 (6141)
* Wed Jun 01 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-05-30 (6138)
* Sat May 07 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-05-09 (6133)
* Wed Apr 20 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-04-25 (6127)
* Wed Apr 13 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-04-20 (6124)
* Wed Apr 06 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-04-11 (6121)
* Thu Mar 17 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-03-21 (6112)
* Thu Feb 24 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-02-28 (6102)
* Fri Feb 04 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-02-07 (6090)
* Thu Feb 03 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-02-04 (6093)
* Thu Jan 27 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-02-09 (6085)
* Mon Jan 17 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-01-24
* Thu Jan 06 2022 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2022-01-12 (6069)
* Thu Dec 09 2021 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.10.6 release
* Tue Dec 07 2021 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.10.6 release
* Mon Nov 29 2021 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.10.6 release
* Fri Oct 22 2021 Marcus Klein <marcus.klein@open-xchange.com>
First preview for 7.10.6 release
* Tue May 18 2021 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.10.6 release
* Fri Feb 05 2021 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.10.5 release
* Mon Feb 01 2021 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.10.5 release
* Fri Jan 15 2021 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.10.5 release
* Thu Dec 17 2020 Marcus Klein <marcus.klein@open-xchange.com>
Second preview of 7.10.5 release
* Fri Nov 27 2020 Marcus Klein <marcus.klein@open-xchange.com>
First preview of 7.10.5 release
* Tue Oct 06 2020 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.10.5 release
* Wed Aug 05 2020 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.10.4 release
* Tue Aug 04 2020 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.10.4 release
* Tue Aug 04 2020 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.10.4 release
* Fri Jul 31 2020 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.10.4 release
* Tue Jul 28 2020 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.10.4 release
* Tue Jun 30 2020 Marcus Klein <marcus.klein@open-xchange.com>
Second preview of 7.10.4 release
* Wed May 20 2020 Marcus Klein <marcus.klein@open-xchange.com>
First preview of 7.10.4 release
* Thu Jan 16 2020 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.10.4 release
* Thu Nov 28 2019 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.10.3 release
* Thu Nov 21 2019 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.10.3 release
* Thu Oct 17 2019 Marcus Klein <marcus.klein@open-xchange.com>
First preview for 7.10.3 release
* Mon Jun 17 2019 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.10.3 release
* Fri May 10 2019 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.10.2 release
* Fri May 10 2019 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.10.2 release
* Tue Apr 30 2019 Marcus Klein <marcus.klein@open-xchange.com>
Second preview for 7.10.2 release
* Thu Mar 28 2019 Marcus Klein <marcus.klein@open-xchange.com>
First preview for 7.10.2 release
* Thu Oct 18 2018 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.10.2 release
* Thu Oct 11 2018 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.10.1 release
* Thu Sep 06 2018 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.10.1 release
* Fri Jun 29 2018 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.10.0 release
* Wed Jun 27 2018 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.10.0 release
* Mon Jun 25 2018 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.10.0 release
* Mon Jun 11 2018 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.10.0 release
* Fri May 18 2018 Marcus Klein <marcus.klein@open-xchange.com>
Sixth preview of 7.10.0 release
* Thu Apr 19 2018 Marcus Klein <marcus.klein@open-xchange.com>
Fifth preview of 7.10.0 release
* Tue Apr 03 2018 Marcus Klein <marcus.klein@open-xchange.com>
Fourth preview of 7.10.0 release
* Tue Feb 20 2018 Marcus Klein <marcus.klein@open-xchange.com>
Third preview of 7.10.0 release
* Fri Feb 02 2018 Marcus Klein <marcus.klein@open-xchange.com>
Second preview for 7.10.0 release
* Fri Dec 01 2017 Marcus Klein <marcus.klein@open-xchange.com>
First preview for 7.10.0 release
* Thu Oct 12 2017 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.10.0 release
* Fri May 19 2017 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.8.4 release
* Thu May 04 2017 Marcus Klein <marcus.klein@open-xchange.com>
Second preview of 7.8.4 release
* Mon Apr 03 2017 Marcus Klein <marcus.klein@open-xchange.com>
First preview of 7.8.4 release
* Fri Nov 25 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.8.3 release
* Thu Nov 24 2016 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.8.3 release
* Thu Nov 24 2016 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.8.4 release
* Tue Nov 15 2016 Marcus Klein <marcus.klein@open-xchange.com>
Third preview for 7.8.3 release
* Sat Oct 29 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second preview for 7.8.3 release
* Fri Oct 14 2016 Marcus Klein <marcus.klein@open-xchange.com>
First preview 7.8.3 release
* Tue Sep 06 2016 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.8.3 release
* Tue Jul 12 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.8.2 release
* Wed Jul 06 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.8.2 release
* Wed Jun 29 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.8.2 release
* Thu Jun 16 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.8.2 release
* Wed Apr 06 2016 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.8.2 release
* Wed Mar 30 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.8.1 release
* Fri Mar 25 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.8.1 release
* Tue Mar 15 2016 Marcus Klein <marcus.klein@open-xchange.com>
Fifth preview for 7.8.1 release
* Fri Mar 04 2016 Marcus Klein <marcus.klein@open-xchange.com>
Fourth preview for 7.8.1 release
* Sat Feb 20 2016 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.8.1 release
* Wed Feb 03 2016 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.8.1 release
* Tue Jan 26 2016 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.8.1 release
* Tue Oct 20 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-10-26 (2813)
* Mon Oct 19 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-10-30 (2818)
* Mon Oct 19 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-10-26 (2812)
* Mon Oct 12 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-10-23 (2806)
* Thu Oct 08 2015 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.8.1
* Fri Oct 02 2015 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.8.0 release
* Wed Sep 30 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-10-12 (2784)
* Fri Sep 25 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-09-28 (2767)
* Fri Sep 25 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fith candidate for 7.8.0 release
* Fri Sep 18 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.8.0 release
* Tue Sep 08 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-09-14 (2732)
* Mon Sep 07 2015 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.8.0 release
* Wed Sep 02 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-09-01 (2726)
* Mon Aug 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-24 (2674)
* Fri Aug 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.8.0 release
* Mon Aug 17 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-12 (2671)
* Thu Aug 06 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-17 (2666)
* Wed Aug 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.8.0
* Tue Aug 04 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-10 (2655)
* Mon Aug 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-03 (2650)
* Thu Jul 23 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-07-27 (2626)
* Wed Jul 15 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-07-20 (2614)
* Fri Jul 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-07-10
* Fri Jul 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-07-02 (2611)
* Fri Jul 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-29 (2578)
* Fri Jul 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-29 (2542)
* Wed Jun 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-29 (2569)
* Wed Jun 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-26 (2573)
* Wed Jun 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-08 (2539)
* Wed Jun 10 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-08 (2540)
* Mon May 18 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-05-26 (2521)
* Fri May 15 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-05-15 (2529)
* Fri May 08 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-05-12 (2478)
* Thu Apr 30 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-05-04 (2496)
* Thu Apr 30 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-05-04 (2497)
* Tue Apr 28 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-05-04 (2505)
* Fri Apr 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-09-09 (2495)
* Tue Apr 14 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-04-13 (2473)
* Wed Apr 08 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-04-13 (2474)
* Tue Apr 07 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-09 (2486)
* Thu Mar 26 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-03-30 (2459)
* Mon Mar 23 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-03-20
* Tue Mar 17 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-03-18
* Fri Mar 13 2015 Marcus Klein <marcus.klein@open-xchange.com>
Twelfth candidate for 7.6.2 release
* Fri Mar 06 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-03-16
* Fri Mar 06 2015 Marcus Klein <marcus.klein@open-xchange.com>
Eleventh candidate for 7.6.2 release
* Wed Mar 04 2015 Marcus Klein <marcus.klein@open-xchange.com>
Tenth candidate for 7.6.2 release
* Tue Mar 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Nineth candidate for 7.6.2 release
* Thu Feb 26 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-02-23
* Tue Feb 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Eighth candidate for 7.6.2 release
* Mon Feb 23 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-02-25
* Thu Feb 12 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-02-23
* Thu Feb 12 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-02-23
* Wed Feb 11 2015 Marcus Klein <marcus.klein@open-xchange.com>
Seventh candidate for 7.6.2 release
* Fri Feb 06 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-02-10
* Fri Feb 06 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-02-09
* Fri Jan 30 2015 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.6.2 release
* Wed Jan 28 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.6.2 release
* Mon Jan 26 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-27
* Mon Jan 26 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-01-26
* Wed Jan 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-01-29
* Mon Jan 12 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-01-09
* Wed Jan 07 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-01-12
* Mon Jan 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-01-12
* Tue Dec 30 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-01-12
* Tue Dec 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-10
* Fri Dec 12 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.6.2 release
* Mon Dec 08 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-15
* Mon Dec 08 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-10
* Mon Dec 08 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-15
* Fri Dec 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.6.2 release
* Thu Dec 04 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-09
* Tue Dec 02 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-03
* Tue Nov 25 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-01
* Mon Nov 24 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-01
* Mon Nov 24 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-01
* Fri Nov 21 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.6.2 release
* Thu Nov 20 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-01
* Wed Nov 19 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-21
* Tue Nov 18 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-20
* Mon Nov 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-17
* Mon Nov 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-17
* Mon Nov 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-17
* Wed Nov 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.8.0 release
* Tue Nov 04 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-10
* Fri Oct 31 2014 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.6.2 release
* Tue Oct 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-03
* Mon Oct 27 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-30
* Fri Oct 24 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-04
* Fri Oct 24 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-03
* Fri Oct 24 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-22
* Fri Oct 17 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-24
* Tue Oct 14 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.6.1 release
* Fri Oct 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-20
* Fri Oct 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.6.1 release
* Fri Oct 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-20
* Thu Oct 09 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-13
* Tue Oct 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-09
* Tue Oct 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-09
* Tue Oct 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-10
* Thu Oct 02 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.6.1
* Tue Sep 30 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-06
* Fri Sep 26 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-09-29
* Fri Sep 26 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-06
* Tue Sep 23 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-02
* Thu Sep 18 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-09-23
* Wed Sep 17 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.6.2 release
* Tue Sep 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.6.1
* Mon Sep 08 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-09-15
* Mon Sep 08 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-09-15
* Fri Sep 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.6.1
* Thu Aug 21 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-25
* Wed Aug 20 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-25
* Mon Aug 18 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-25
* Wed Aug 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-15
* Tue Aug 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-06
* Mon Aug 04 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-11
* Mon Aug 04 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-11
* Mon Jul 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-30
* Mon Jul 21 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-28
* Tue Jul 15 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-21
* Mon Jul 14 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-24
* Thu Jul 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-15
* Mon Jul 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-14
* Mon Jul 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-07
* Tue Jul 01 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-07
* Thu Jun 26 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.6.1
* Mon Jun 23 2014 Marcus Klein <marcus.klein@open-xchange.com>
Seventh candidate for 7.6.0 release
* Fri Jun 20 2014 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 7.6.0
* Wed Jun 18 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-06-30
* Fri Jun 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 7.6.0
* Fri Jun 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-06-23
* Thu Jun 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-06-16
* Fri May 30 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 7.6.0
* Thu May 22 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-05-26
* Fri May 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-05-26
* Fri May 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.6.0
* Wed May 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-05-05
* Mon May 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.6.0
* Fri Apr 25 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-04-29
* Tue Apr 15 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-04-22
* Fri Apr 11 2014 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.6.0
* Thu Apr 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-04-11
* Thu Apr 03 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-04-07
* Mon Mar 31 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-03-31
* Wed Mar 19 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-03-21
* Mon Mar 17 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-03-24
* Thu Mar 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-03-13
* Mon Mar 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-03-12
* Fri Mar 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-03-07
* Tue Mar 04 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-03-05
* Tue Feb 25 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-03-10
* Tue Feb 25 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-26
* Fri Feb 21 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-28
* Fri Feb 21 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-26
* Tue Feb 18 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-20
* Wed Feb 12 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.6.0
* Fri Feb 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 7.4.2
* Thu Feb 06 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 7.4.2
* Thu Feb 06 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-11
* Tue Feb 04 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 7.4.2
* Fri Jan 31 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-03
* Thu Jan 30 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-03
* Wed Jan 29 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-30
* Tue Jan 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-31
* Tue Jan 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-30
* Tue Jan 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-30
* Mon Jan 27 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-30
* Fri Jan 24 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-17
* Thu Jan 23 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.4.2
* Wed Jan 22 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-22
* Mon Jan 20 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-20
* Thu Jan 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-16
* Mon Jan 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-14
* Fri Jan 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.4.2
* Fri Jan 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-17
* Fri Jan 03 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-06
* Mon Dec 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-09
* Mon Dec 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.4.2
* Thu Dec 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-23
* Thu Dec 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-23
* Thu Dec 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-23
* Wed Dec 18 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.4.2
* Tue Dec 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-19
* Tue Dec 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-18
* Tue Dec 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-16
* Thu Dec 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-12
* Thu Dec 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-12
* Mon Dec 09 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-09
* Fri Dec 06 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-29
* Fri Dec 06 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-10
* Tue Dec 03 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-28
* Wed Nov 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.4.1 release
* Tue Nov 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.4.1 release
* Mon Nov 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-12
* Mon Nov 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-12
* Fri Nov 08 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-11
* Thu Nov 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-08
* Thu Nov 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.4.1 release
* Tue Nov 05 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-12
* Wed Oct 30 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-28
* Thu Oct 24 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-30
* Thu Oct 24 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-30
* Wed Oct 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.4.1 release
* Tue Oct 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-23
* Mon Oct 21 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-21
* Thu Oct 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-21
* Tue Oct 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-11
* Mon Oct 14 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-21
* Mon Oct 14 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-15
* Thu Oct 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
First sprint increment for 7.4.0 release
* Wed Oct 09 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-09
* Wed Oct 09 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-07
* Thu Sep 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-23
* Tue Sep 24 2013 Marcus Klein <marcus.klein@open-xchange.com>
Eleventh candidate for 7.4.0 release
* Fri Sep 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.4.1 release
* Fri Sep 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Tenth candidate for 7.4.0 release
* Thu Sep 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Ninth candidate for 7.4.0 release
* Wed Sep 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-12
* Wed Sep 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-12
* Thu Sep 05 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-05
* Mon Sep 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-26
* Mon Sep 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Eighth candidate for 7.4.0 release
* Fri Aug 30 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-30
* Wed Aug 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-03
* Tue Aug 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
Seventh candidate for 7.4.0 release
* Fri Aug 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.4.0 release
* Thu Aug 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-22
* Thu Aug 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-22
* Tue Aug 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-19
* Mon Aug 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-21
* Mon Aug 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 7.4.0
* Tue Aug 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 7.4.0
* Tue Aug 06 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.4.0
* Mon Aug 05 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-09
* Fri Aug 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-02
* Fri Aug 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.4.0
* Fri Jul 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-07-26
* Wed Jul 24 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-02
* Wed Jul 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.4.0
* Tue Jul 16 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.4.0
* Mon Jul 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second build for patch 2013-07-18
* Mon Jul 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-07-18
* Fri Jul 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-07-18
* Fri Jul 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-07-18
* Thu Jul 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-07-10
* Wed Jul 03 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-27
* Mon Jul 01 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.2.2 release
* Fri Jun 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.2.2 release
* Wed Jun 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
Release candidate for 7.2.2 release
* Tue Jun 25 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-07-05
* Mon Jun 24 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-21
* Fri Jun 21 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second feature freeze for 7.2.2 release
* Mon Jun 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-11
* Mon Jun 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Feature freeze for 7.2.2 release
* Tue Jun 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-13
* Mon Jun 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-11
* Fri Jun 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-06-20
* Mon Jun 03 2013 Marcus Klein <marcus.klein@open-xchange.com>
First sprint increment for 7.2.2 release
* Wed May 29 2013 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.2.2 release
* Tue May 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second build for patch 2013-05-28
* Mon May 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.2.2
* Thu May 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.2.1 release
* Wed May 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-22
* Wed May 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-22
* Wed May 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-22
* Wed May 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.2.1 release
* Wed May 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-10
* Mon May 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-09
* Mon May 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-09
* Mon May 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-09
* Mon May 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-09
* Mon May 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-09
* Tue May 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-08
* Fri May 03 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-23
* Tue Apr 30 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-17
* Sun Apr 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-25
* Mon Apr 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.2.1 release
* Thu Apr 18 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-30
* Wed Apr 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-09
* Mon Apr 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.2.1
* Fri Apr 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-12
* Wed Apr 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.2.0 release
* Tue Apr 09 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.2.0 release
* Tue Apr 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.2.0 release
* Tue Apr 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-04
* Tue Apr 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-04
* Tue Apr 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-04
* Tue Apr 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-04-04
* Tue Mar 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.2.0
* Mon Mar 18 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-03-18
* Fri Mar 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.2.0
* Tue Mar 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 6.22.2/7.0.2
* Mon Mar 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.2/7.0.2
* Fri Mar 08 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.2/7.0.2
* Fri Mar 08 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.2/7.0.2
* Thu Mar 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.2/7.0.2
* Mon Mar 04 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-03-07
* Mon Mar 04 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-03-08
* Fri Mar 01 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-03-07
* Wed Feb 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.2/7.0.2
* Tue Feb 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-02-22
* Mon Feb 25 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-02-22
* Tue Feb 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 7.0.1
* Tue Feb 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.0.1
* Tue Feb 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.0.2 release
* Fri Feb 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-02-13
* Thu Feb 14 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.0.1
* Fri Feb 01 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.0.1
* Tue Jan 29 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-01-28
* Mon Jan 21 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-01-24
* Tue Jan 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-01-23
* Thu Jan 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-01-10
* Thu Jan 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.0.1
* Thu Jan 03 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for public patch 2013-01-15
* Fri Dec 28 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for public patch 2012-12-31
* Fri Dec 21 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for public patch 2012-12-21
* Tue Dec 18 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-12-27
* Tue Dec 18 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.0.0
* Mon Dec 17 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.0.0
* Wed Dec 12 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for public patch 2012-12-04
* Tue Dec 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.0.0
* Tue Dec 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.0.0 release
* Mon Nov 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-11-28
* Wed Nov 14 2012 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 6.22.1
* Tue Nov 13 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.1
* Tue Nov 13 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for EDP drop #6
* Mon Nov 12 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-11-08
* Thu Nov 08 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-11-08
* Tue Nov 06 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.1
* Mon Nov 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-10-31
* Fri Nov 02 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.1
* Wed Oct 31 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.1
* Wed Oct 31 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-10-31
* Tue Oct 30 2012 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2012-10-29
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release build for EDP drop #5
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.1
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release build for EDP drop #5
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.1
* Thu Oct 11 2012 Marcus Klein <marcus.klein@open-xchange.com>
Release build for EDP drop #5
* Wed Oct 10 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.0
* Tue Oct 09 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.0
* Fri Oct 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.0
* Thu Oct 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.0
* Tue Sep 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.23.0
* Mon Sep 03 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for next EDP drop
* Tue Aug 21 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.0
* Mon Aug 20 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.0
* Tue Jul 03 2012 Marcus Klein <marcus.klein@open-xchange.com>
Release build for EDP drop #2
* Mon Jun 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
Release build for EDP drop #2
* Tue May 22 2012 Marcus Klein <marcus.klein@open-xchange.com>
Internal release build for EDP drop #2
* Mon Apr 16 2012 Marcus Klein <marcus.klein@open-xchange.com>
Internal release build for EDP drop #1
* Wed Apr 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
Internal release build for EDP drop #0
* Mon Oct 17 2011 Marcus Klein <marcus.klein@open-xchange.com>
Initial release
