package liquibase.datatype.core;

import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.servicelocator.PrioritizedService;

@DataTypeInfo(name="nchar", aliases = "java.sql.Types.NCHAR", minParameters = 0, maxParameters = 1, priority = PrioritizedService.PRIORITY_DEFAULT)
public class NCharType extends CharType {

    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof HsqlDatabase) {
            return new DatabaseDataType("CHAR", getParameters());
        }
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("NCHAR2", getParameters());
        }
        return super.toDatabaseDataType(database);
    }

}