/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.groupware.settings.tree.modules.personaldata;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.ReadOnlyValue;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.tree.AbstractModules;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Strings;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import com.openexchange.user.User;

/**
 * {@link InternalUserEditEnabled} - Indicates if permission to edit internal user setting is enabled.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since Open-Xchange v6.16
 */
public class InternalUserEditEnabled extends AbstractModules {

    /**
     * Initializes a new {@link InternalUserEditEnabled}.
     */
    public InternalUserEditEnabled() {
        super();
    }

    @Override
    public String[] getPath() {
        return new String[] { "modules", "com.openexchange.user.personaldata", "internal_user_edit" };
    }

    @Override
    public IValueHandler getSharedValue() {
        return new ReadOnlyValue() {

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                if (user.isGuest() && Strings.isEmpty(user.getMail())) {
                    /*
                     * prevent edit of user data for anonymous guests
                     */
                    setting.setSingleValue(Boolean.FALSE);
                } else {
                    setting.setSingleValue(Boolean.valueOf(getModule(userConfig)));
                }
            }

            @Override
            public boolean isAvailable(final UserConfiguration userConfig) {
                return true;
            }
        };
    }

    @Override
    protected boolean getModule(final UserConfiguration userConfig) {
        return OXFolderProperties.isEnableInternalUsersEdit();
    }

}
