/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.folderstorage.mail;

import com.openexchange.exception.OXException;

/**
 * {@link DefaultFolderFullnameProvider}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public interface DefaultFolderFullnameProvider {

    /**
     * Gets the full name of default INBOX folder
     *
     * @return The full name of default INBOX folder
     * @throws OXException If INBOX folder's full name cannot be returned
     */
    public String getINBOXFolder() throws OXException;

    /**
     * Gets the full name of default confirmed ham folder
     *
     * @return The full name of default confirmed ham folder
     * @throws OXException If confirmed ham folder's full name cannot be returned
     */
    public String getConfirmedHamFolder() throws OXException;

    /**
     * Gets the full name of default confirmed spam folder
     *
     * @return The full name of default confirmed spam folder
     * @throws OXException If confirmed spam folder's full name cannot be returned
     */
    public String getConfirmedSpamFolder() throws OXException;

    /**
     * Gets the full name of default drafts folder
     *
     * @return The full name of default drafts folder
     * @throws OXException If draft folder's full name cannot be returned
     */
    public String getDraftsFolder() throws OXException;

    /**
     * Gets the full name of default spam folder
     *
     * @return The full name of default spam folder
     * @throws OXException If spam folder's full name cannot be returned
     */
    public String getSpamFolder() throws OXException;

    /**
     * Gets the full name of default sent folder
     *
     * @return The full name of default sent folder
     * @throws OXException If sent folder's full name cannot be returned
     */
    public String getSentFolder() throws OXException;

    /**
     * Gets the full name of default trash folder
     *
     * @return The full name of default trash folder
     * @throws OXException If trash folder's full name cannot be returned
     */
    public String getTrashFolder() throws OXException;

}
