/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.contact.vcard;

/**
 * {@link VCardVersion} - An enumeration of VCard versions.
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 * @since v7.8.0
 */
public enum VCardVersion {

    /**
     * VCard v2.1
     */
    VERSION_2_1("2.1"),
    /**
     * VCard v3.0
     */
    VERSION_3_0("3.0"),
    /**
     * VCard v4.0
     */
    VERSION_V4_0("4.0"),
    ;

    private final String version;

    /**
     * Initializes a new {@link VCardVersion}.
     *
     * @param version The version string
     */
    private VCardVersion(String version) {
        this.version = version;
    }

    /**
     * Gets the version string.
     *
     * @return The version
     */
    public String getVersion() {
        return version;
    }

}
