/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.contact.provider.composition;

import com.openexchange.exception.OXException;
import com.openexchange.osgi.annotation.SingletonService;
import com.openexchange.session.Session;

/**
 * {@link IDBasedContactsAccessFactory}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 * @since v7.10.5
 */
@SingletonService
public interface IDBasedContactsAccessFactory {

    /**
     * Initializes a new ID-based contacts access (in default compositing mode, including external contact providers) for the supplied
     * session, using fully qualified folder identifiers.
     * 
     * @param session The session to create the access for
     * @return The contacts access
     */
    IDBasedContactsAccess createAccess(Session session) throws OXException;

    /**
     * Initializes a new ID-based contacts access (in legacy <i>internal</i> mode, excluding external contact providers) for the supplied
     * session, without qualifying the internal folder identifiers.
     * 
     * @param session The session to create the access for
     * @return The contact access
     */
    IDBasedContactsAccess createInternalAccess(Session session) throws OXException;

}
