/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.consistency;

import com.openexchange.i18n.LocalizableStrings;

/**
 * {@link ConsistencyExceptionMessages}
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class ConsistencyExceptionMessages implements LocalizableStrings {

    // The policy you have entered is malformed. It should look like \"condition:action\"
    public static final String MALFORMED_POLICY_MSG_DISPLAY = "The policy you have entered is malformed. It should look like \"condition:action\"";

    // The policy '%s' you have specified is unknonw/unsupported.
    public static final String UNKNOWN_POLICY_MSG_DISPLAY = "The policy '%s' you have specified is unknonw/unsupported.";

    private ConsistencyExceptionMessages() {
        super();
    }
}
