/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.pgp.core.packethandling;

import org.bouncycastle.bcpg.Packet;

/**
 * {@link PGPPacket} represents a wrapper around a BouncyCastle PGP Message Packet
 *
 * @author <a href="mailto:benjamin.gruedelbach@open-xchange.com">Benjamin Gruedelbach</a>
 * @since v7.8.4
 */
public class PGPPacket {

    private final Packet bcPacket;
    private final byte[] bcPacketHeader;

    /**
     * Initializes a new {@link PGPPacket}.
     *
     * @param bcPacket
     * @param bcPacketHeader
     */
    public PGPPacket(Packet bcPacket, byte[] bcPacketHeader) {
        super();
        this.bcPacket = bcPacket;
        this.bcPacketHeader = bcPacketHeader;
    }

    /**
     * Gets the packet header
     *
     * @return The header of the packet, or null if the header is unknown
     */
    public byte[] getBcPacketHeader() {
        return bcPacketHeader;
    }

    /**
     * Gets the packet
     *
     * @return The packet
     */
    public Packet getBcPacket() {
        return bcPacket;
    }
}
