/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.osgi;

import org.osgi.framework.ServiceReference;

/**
 * {@link SimpleRegistryListener}
 *
 * @author <a href="mailto:francisco.laguna@open-xchange.com">Francisco Laguna</a>
 */
public interface SimpleRegistryListener<T> {

    /**
     * The service is being added to this {@code SimpleRegistryListener}.
     *
     * @param ref The reference to the service being added
     * @param service The (tracked) service object
     */
    public void added(ServiceReference<T> ref, T service);

    /**
     * The service is being removed from this {@code SimpleRegistryListener}.
     *
     * @param ref The reference to the service being removed
     * @param service The (tracked) service object
     */
    public void removed(ServiceReference<T> ref, T service);

}
