/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */


package com.openexchange.java;


/**
 * {@link Buffers} - Utility class for buffering and buffers.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v8.x
 */
public final class Buffers {

    /**
     * Initializes a new instance of {@link Buffers}.
     */
    private Buffers() {
        super();
    }

    /** The buffer size of 128 bytes */
    public static final int BUFFER_SIZE_128 = 128;

    /** The buffer size of 256 bytes */
    public static final int BUFFER_SIZE_256 = 256;

    /** The buffer size of 512 bytes */
    public static final int BUFFER_SIZE_512 = 512;

    /** The buffer size of 1 KB */
    public static final int BUFFER_SIZE_1K = 1024;

    /** The buffer size of 2 KB */
    public static final int BUFFER_SIZE_2K = 2048;

    /** The buffer size of 4 KB */
    public static final int BUFFER_SIZE_4K = 4096;

    /** The buffer size of 8 KB */
    public static final int BUFFER_SIZE_8K = 8192;

    /** The buffer size of 64 KB */
    public static final int BUFFER_SIZE_64K = 65536;

    /** The buffer size of 1 MB */
    public static final int BUFFER_SIZE_1MB = 1_048_576;

}
