/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.hazelcast.configuration.ssl;

import java.util.Properties;
import com.openexchange.config.ConfigurationService;
import com.openexchange.hazelcast.ssl.HazelcastSSLConstants;
import com.openexchange.java.Strings;

/**
 * {@link HazelcastSSLUtility}
 *
 * @author <a href="mailto:daniel.becker@open-xchange.com">Daniel Becker</a>
 * @since v7.10.1
 */
public class HazelcastSSLUtility {

    /**
     * Initializes a new {@link HazelcastSSLUtility}.
     */
    private HazelcastSSLUtility() {
        super();
    }

    /**
     * Gets all necessary properties for an SSL configuration
     *
     * @param configService The {@link ConfigurationService} to get the properties from
     * @return The SSL properties
     */
    public static Properties getPropertiesFromService(ConfigurationService configService) {
        Properties properties = new Properties();
        for (String propertyName : HazelcastSSLConstants.getSslPropertyNames()) {
            String value = configService.getProperty(propertyName);
            if (Strings.isNotEmpty(value)) {
                properties.setProperty(propertyName, value);
            }
        }
        return properties;
    }
}
