/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.geolocation;

import java.net.InetAddress;
import com.openexchange.annotation.Nullable;
import com.openexchange.exception.OXException;

/**
 * {@link GeoLocationStorageService}
 *
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 * @since v7.10.2
 */
public interface GeoLocationStorageService {

    /**
     * Retrieves the {@link GeoInformation} of the specified IP address from the storage
     * 
     * @param contextId The context identifier
     * @param address The IP address to lookup
     * @return The Geographical information for the specified IP address or <code>null</code> if no location could be determined
     * @throws OXException If the specified IP address is invalid or Geographical information cannot be returned
     *             or any other error is occurred
     */
    @Nullable
    GeoInformation getGeoInformation(int contextId, InetAddress address) throws OXException;

    /**
     * Returns the service provider identifier
     * 
     * @return the service provider identifier
     */
    String getProviderId();
}
