/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.geolocation;

/**
 * {@link GeoInformation} - Represents geo information for an IP address.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.8.4
 */
public interface GeoInformation {

    /**
     * Gets the continent
     *
     * @return The continent
     */
    String getContinent();

    /**
     * Gets the country
     *
     * @return The country
     */
    String getCountry();

    /**
     * Gets the city
     *
     * @return The city
     */
    String getCity();

    /**
     * Gets the postalCode
     *
     * @return The postalCode
     */
    String getPostalCode();

    /**
     * Gets the hasContinent
     *
     * @return The hasContinent
     */
    boolean hasContinent();

    /**
     * Gets the hasCountry
     *
     * @return The hasCountry
     */
    boolean hasCountry();

    /**
     * Gets the hasCity
     *
     * @return The hasCity
     */
    boolean hasCity();

    /**
     * Gets the hasPostalCode
     *
     * @return The hasPostalCode
     */
    boolean hasPostalCode();

}
