/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.folder.json.osgi;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.customizer.folder.AdditionalFolderFieldList;

/**
 * {@link FolderFieldCollector} - Collector for additional folder fields.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public class FolderFieldCollector implements ServiceTrackerCustomizer<AdditionalFolderField, AdditionalFolderField> {

    /**
     * The list.
     */
    private final AdditionalFolderFieldList list;

    /**
     * The bundle context.
     */
    private final BundleContext context;

    /**
     * Initializes a new {@link FolderFieldCollector}.
     *
     * @param context The bundle context
     * @param list The additional folder field list used to store tracked fields.
     */
    public FolderFieldCollector(final BundleContext context, final AdditionalFolderFieldList list) {
        super();
        this.list = list;
        this.context = context;
    }

    @Override
    public AdditionalFolderField addingService(final ServiceReference<AdditionalFolderField> reference) {
        final AdditionalFolderField field = context.getService(reference);
        list.addField(field);
        return field;
    }

    @Override
    public void modifiedService(final ServiceReference<AdditionalFolderField> reference, final AdditionalFolderField service) {
        // Nothing to do
    }

    @Override
    public void removedService(final ServiceReference<AdditionalFolderField> reference, final AdditionalFolderField service) {
        try {
            final AdditionalFolderField field = service;
            list.remove(field.getColumnID());
        } finally {
            context.ungetService(reference);
        }
    }

}
