/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.filestore;

import java.net.URI;
import com.openexchange.exception.OXException;
import com.openexchange.osgi.annotation.SingletonService;

/**
 * {@link DatabaseAccessService} - A registry for database access providers.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.8.3
 */
@SingletonService
public interface DatabaseAccessService extends DatabaseAccessProvider {

    /**
     * Gets the database access for specified arguments.
     *
     * @param fileStorageId The identifier of the file storage
     * @param prefix The prefix in use
     * @return The best-ranked database access or <code>null</code>
     * @throws OXException If access cannot be determined
     */
    @Override
    DatabaseAccess getAccessFor(int fileStorageId, String prefix) throws OXException;

    /**
     * Gets the database access for specified arguments.
     *
     * @param uri The URI of the file storage
     * @param prefix The prefix in use
     * @return The best-ranked database access or <code>null</code>
     * @throws OXException If access cannot be determined
     */
    @Override
    DatabaseAccess getAccessFor(URI uri, String prefix) throws OXException;

}
