/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.file.storage;

import com.openexchange.exception.OXException;


/**
 * Extended interface for {@link FileStorageService} inheritors that come along with a
 * {@link AdministrativeFileStorageFileAccess} implementation.
 *
 * @author <a href="mailto:steffen.templin@open-xchange.com">Steffen Templin</a>
 * @since v7.8.0
 */
public interface AdministrativeFileStorageService extends FileStorageService {

    /**
     * Gets the {@link AdministrativeFileStorageFileAccess} for the given account id.
     *
     * @param accountId The account ID
     * @param contextId The according context ID
     * @return The administrative file access
     * @throws OXException
     */
    AdministrativeFileStorageFileAccess getAdministrativeFileAccess(String accountId, int contextId) throws OXException;

}
