/*
* @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
* @license AGPL-3.0
*
* This code is free software: you can redistribute it and/or modify
* it under the terms of the GNU Affero General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Affero General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public License
* along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
* 
* Any use of the work other than as authorized under this license or copyright law is prohibited.
*
*/

package com.openexchange.chronos.scheduling.impl.incoming;

import java.util.Optional;
import com.openexchange.annotation.NonNull;
import com.openexchange.chronos.CalendarObjectResource;
import com.openexchange.chronos.scheduling.IncomingSchedulingMessage;
import com.openexchange.chronos.scheduling.IncomingSchedulingObject;
import com.openexchange.chronos.scheduling.SchedulingMethod;

/**
 * 
 * {@link DelegatingSchedulingMessage}
 *
 * @author <a href="mailto:daniel.becker@open-xchange.com">Daniel Becker</a>
 * @since v7.10.6
 */
public class DelegatingSchedulingMessage implements IncomingSchedulingMessage {

    private final IncomingSchedulingMessage delegatee;

    /**
     * Initializes a new {@link DelegatingSchedulingMessage}.
     * 
     * @param delegatee The message to delegate to
     *
     */
    public DelegatingSchedulingMessage(IncomingSchedulingMessage delegatee) {
        super();
        this.delegatee = delegatee;
    }

    @Override
    @NonNull
    public SchedulingMethod getMethod() {
        return delegatee.getMethod();
    }

    @Override
    public int getTargetUser() {
        return delegatee.getTargetUser();
    }

    @Override
    @NonNull
    public IncomingSchedulingObject getSchedulingObject() {
        return delegatee.getSchedulingObject();
    }

    @Override
    @NonNull
    public CalendarObjectResource getResource() {
        return delegatee.getResource();
    }

    @Override
    public <T> Optional<T> getAdditional(String key, Class<T> clazz) {
        return delegatee.getAdditional(key, clazz);
    }

}
