/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.chronos.common;

import java.util.Collections;
import java.util.List;
import com.openexchange.chronos.service.SearchFilter;

/**
 * {@link DefaultSearchFilter}
 *
 * @author <a href="mailto:tobias.friedrich@open-xchange.com">Tobias Friedrich</a>
 * @since v7.10.0
 */
public class DefaultSearchFilter implements SearchFilter {

    private final String id;
    private final List<String> fields;
    private final List<String> queries;

    /**
     * Initializes a new {@link DefaultSearchFilter}.
     *
     * @param id The filter identifier, or <code>null</code> if it is the only filter in the facet
     * @param fields The fields to filter on
     * @param queries The queries to search for
     */
    public DefaultSearchFilter(String id, List<String> fields, List<String> queries) {
        super();
        this.id = id;
        this.fields = fields;
        this.queries = queries;
    }

    /**
     * Initializes a new {@link DefaultSearchFilter}.
     *
     * @param field The field to filter on
     * @param queries The queries to search for
     */
    public DefaultSearchFilter(String field, List<String> queries) {
        this(null, Collections.singletonList(field), queries);
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public List<String> getFields() {
        return fields;
    }

    @Override
    public List<String> getQueries() {
        return queries;
    }

}
