/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.chronos.alarm.sms;

import static com.openexchange.java.Autoboxing.I;
import static com.openexchange.java.Autoboxing.L;
import com.openexchange.config.lean.DefaultProperty;
import com.openexchange.config.lean.Property;

/**
 * {@link SMSAlarmConfig}
 *
 * @author <a href="mailto:kevin.ruthmann@open-xchange.com">Kevin Ruthmann</a>
 * @since v7.10.1
 */
public class SMSAlarmConfig {

    private static final String PREFIX = "com.openexchange.calendar.alarm.sms.";

    /**
     * Defines the time in milliseconds an alarm sms should be send out before the trigger time.
     * With this property the admin can configure the average time needed by the sms system to send out the sms.
     * This way the sms should usually be send out on time and not a few seconds late.
     */
    public static final Property SMS_SHIFT = DefaultProperty.valueOf(PREFIX + "time.shift", I(0));

    /**
     * Enabled or disables sms alarms.
     */
    public static final Property SMS_ENABLED = DefaultProperty.valueOf(PREFIX + "enabled", Boolean.FALSE);

    /**
     * The amount of sms allowed to be sent in a given timeframe (see {@link #SMS_LIMIT_TIME_FRAME})
     */
    public static final Property SMS_LIMIT_AMOUNT = DefaultProperty.valueOf(PREFIX + "limit.amount", I(50));

    /**
     * The timeframe in milliseconds used for the amount limit (see {@link #SMS_LIMIT_AMOUNT}
     */
    public static final Property SMS_LIMIT_TIME_FRAME = DefaultProperty.valueOf(PREFIX + "limit.timeframe", L(60000l));

}
