/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.util.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.util.collection.CollectionCreator;
import org.apache.ctakes.core.util.collection.CollectionMap;

public final class DefaultCollectionMap<K, V, T extends Collection<V>>
implements CollectionMap<K, V, T> {
    private final Map<K, T> _delegate;
    private final CollectionCreator<V, T> _collectionCreator;
    private final T EMPTY_COLLECTION;

    public DefaultCollectionMap(Map<K, T> delegate, CollectionCreator<V, T> collectionCreator) {
        this._delegate = delegate;
        this._collectionCreator = collectionCreator;
        this.EMPTY_COLLECTION = collectionCreator.createCollection();
    }

    @Override
    public Iterator<Map.Entry<K, T>> iterator() {
        final Iterator<Map.Entry<K, T>> setIterator = this._delegate.entrySet().iterator();
        return new Iterator<Map.Entry<K, T>>(){

            @Override
            public boolean hasNext() {
                return setIterator.hasNext();
            }

            @Override
            public Map.Entry<K, T> next() {
                final Map.Entry next = (Map.Entry)setIterator.next();
                return new Map.Entry<K, T>(){

                    @Override
                    public K getKey() {
                        return next.getKey();
                    }

                    @Override
                    public T getValue() {
                        return (Collection)next.getValue();
                    }

                    @Override
                    public T setValue(T value) {
                        return null;
                    }
                };
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Collection<T> getAllCollections() {
        return new HashSet<T>(this._delegate.values());
    }

    @Override
    public T getCollection(K key) {
        Collection collection = (Collection)this._delegate.get(key);
        if (collection != null) {
            return (T)collection;
        }
        return this.EMPTY_COLLECTION;
    }

    @Override
    public T getOrCreateCollection(K key) {
        Collection<Object> collection = (Collection)this._delegate.get(key);
        if (collection == null) {
            collection = this._collectionCreator.createCollection();
            this._delegate.put(key, collection);
        }
        return (T)collection;
    }

    @Override
    public boolean containsValue(K key, V value) {
        Collection collection = (Collection)this._delegate.get(key);
        return collection != null && collection.contains(value);
    }

    @Override
    public boolean placeValue(K key, V value) {
        Collection<Object> collection = (Collection)this._delegate.get(key);
        if (collection == null) {
            collection = this._collectionCreator.createCollection();
            this._delegate.put(key, collection);
        }
        return collection.add(value);
    }

    @Override
    public boolean placeMap(Map<K, V> map) {
        boolean placedAny = false;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            boolean placed = this.placeValue(entry.getKey(), entry.getValue());
            placedAny = placedAny || placed;
        }
        return placedAny;
    }

    @Override
    public void removeValue(K key, V value) {
        Collection collection = (Collection)this._delegate.get(key);
        if (collection == null) {
            return;
        }
        collection.remove(value);
    }

    @Override
    public <C extends Collection<V>> int addAllValues(K key, C values) {
        if (values == null || values.isEmpty()) {
            return 0;
        }
        Collection<Object> collection = (Collection)this._delegate.get(key);
        if (collection == null) {
            collection = this._collectionCreator.createCollection();
            this._delegate.put(key, collection);
        }
        int oldSize = collection.size();
        collection.addAll(values);
        return collection.size() - oldSize;
    }

    @Override
    public void clearCollection(K key) {
        Collection collection = (Collection)this._delegate.get(key);
        if (collection != null) {
            collection.clear();
        }
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._delegate.containsValue(value);
    }

    @Override
    public T get(Object key) {
        return (T)((Collection)this._delegate.get(key));
    }

    @Override
    public T put(K key, T value) {
        return (T)((Collection)this._delegate.put(key, value));
    }

    @Override
    public T remove(Object key) {
        return (T)((Collection)this._delegate.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends T> map) {
        this._delegate.putAll(map);
    }

    @Override
    public void clear() {
        this._delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._delegate.keySet();
    }

    @Override
    public Collection<T> values() {
        return this._delegate.values();
    }

    @Override
    public Set<Map.Entry<K, T>> entrySet() {
        return this._delegate.entrySet();
    }

    @Override
    public Map<K, T> toSimpleMap() {
        return this._delegate;
    }
}

