/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.javasimon.AbstractSimon;
import org.javasimon.Counter;
import org.javasimon.CounterImpl;
import org.javasimon.Manager;
import org.javasimon.ManagerConfiguration;
import org.javasimon.Simon;
import org.javasimon.SimonConfiguration;
import org.javasimon.SimonException;
import org.javasimon.SimonFilter;
import org.javasimon.Stopwatch;
import org.javasimon.StopwatchImpl;
import org.javasimon.UnknownSimon;
import org.javasimon.callback.CompositeCallback;
import org.javasimon.callback.CompositeCallbackImpl;
import org.javasimon.clock.SimonClock;
import org.javasimon.utils.SimonUtils;

public final class EnabledManager
implements Manager {
    private UnknownSimon rootSimon;
    private final Map<String, AbstractSimon> allSimons = new ConcurrentHashMap<String, AbstractSimon>();
    private final CompositeCallback callback = new CompositeCallbackImpl();
    private final ManagerConfiguration configuration;
    private final SimonClock clock;

    public EnabledManager() {
        this(SimonClock.SYSTEM);
    }

    public EnabledManager(SimonClock clock) {
        this.clock = clock;
        this.rootSimon = new UnknownSimon("", this);
        this.allSimons.put("", this.rootSimon);
        this.configuration = new ManagerConfiguration(this);
        this.callback.initialize(this);
    }

    @Override
    public Simon getSimon(String name) {
        return this.allSimons.get(name);
    }

    @Override
    public synchronized void destroySimon(String name) {
        if (name.equals("")) {
            throw new SimonException("Root Simon cannot be destroyed!");
        }
        AbstractSimon simon = this.allSimons.remove(name);
        if (simon.getChildren().size() > 0) {
            this.replaceUnknownSimon(simon, UnknownSimon.class);
        } else {
            ((AbstractSimon)simon.getParent()).replaceChild(simon, null);
        }
        this.callback.onSimonDestroyed(simon);
    }

    @Override
    public synchronized void clear() {
        this.allSimons.clear();
        this.rootSimon = new UnknownSimon("", this);
        this.allSimons.put("", this.rootSimon);
        this.callback.onManagerClear();
    }

    @Override
    public Counter getCounter(String name) {
        return (Counter)this.getOrCreateSimon(name, CounterImpl.class);
    }

    @Override
    public Stopwatch getStopwatch(String name) {
        return (Stopwatch)this.getOrCreateSimon(name, StopwatchImpl.class);
    }

    @Override
    public Simon getRootSimon() {
        return this.rootSimon;
    }

    @Override
    public Collection<String> getSimonNames() {
        return Collections.unmodifiableCollection(this.allSimons.keySet());
    }

    @Override
    public Collection<Simon> getSimons(SimonFilter simonFilter) {
        if (simonFilter == null) {
            return Collections.unmodifiableCollection(this.allSimons.values());
        }
        ArrayList<Simon> simons = new ArrayList<Simon>();
        for (AbstractSimon simon : this.allSimons.values()) {
            if (!simonFilter.accept(simon)) continue;
            simons.add(simon);
        }
        return simons;
    }

    private Simon getOrCreateSimon(String name, Class<? extends AbstractSimon> simonClass) {
        if (name == null) {
            return this.instantiateSimon(null, simonClass);
        }
        if (name.equals("")) {
            throw new SimonException("Root Simon cannot be replaced or recreated!");
        }
        AbstractSimon simon = this.allSimons.get(name);
        if (simon != null && simonClass.isInstance(simon)) {
            return simon;
        }
        if (simon != null && !(simon instanceof UnknownSimon)) {
            throw new SimonException("Simon named '" + name + "' already exists and its type is '" + simon.getClass().getName() + "' while requested type is '" + simonClass.getName() + "'.");
        }
        return this.createSimon(name, simonClass);
    }

    private synchronized Simon createSimon(String name, Class<? extends AbstractSimon> simonClass) {
        AbstractSimon simon = this.allSimons.get(name);
        if (simon == null) {
            SimonUtils.validateSimonName(name);
            simon = this.newSimon(name, simonClass);
        } else if (simon instanceof UnknownSimon) {
            simon = this.replaceUnknownSimon(simon, simonClass);
        }
        this.callback.onSimonCreated(simon);
        return simon;
    }

    private AbstractSimon replaceUnknownSimon(AbstractSimon simon, Class<? extends AbstractSimon> simonClass) {
        AbstractSimon newSimon = this.instantiateSimon(simon.getName(), simonClass);
        newSimon.enabled = simon.enabled;
        ((AbstractSimon)simon.getParent()).replaceChild(simon, newSimon);
        for (Simon child : simon.getChildren()) {
            newSimon.addChild((AbstractSimon)child);
            ((AbstractSimon)child).setParent(newSimon);
        }
        this.allSimons.put(simon.getName(), newSimon);
        return newSimon;
    }

    private AbstractSimon newSimon(String name, Class<? extends AbstractSimon> simonClass) {
        AbstractSimon simon = this.instantiateSimon(name, simonClass);
        if (name != null) {
            this.addToHierarchy(simon, name);
            SimonConfiguration config = this.configuration.getConfig(name);
            if (config.getState() != null) {
                simon.setState(config.getState(), false);
            }
            this.allSimons.put(name, simon);
        }
        return simon;
    }

    private AbstractSimon instantiateSimon(String name, Class<? extends AbstractSimon> simonClass) {
        AbstractSimon simon;
        try {
            Constructor<? extends AbstractSimon> constructor = simonClass.getDeclaredConstructor(String.class, Manager.class);
            simon = constructor.newInstance(name, this);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SimonException(e);
        }
        return simon;
    }

    private void addToHierarchy(AbstractSimon simon, String name) {
        String parentName;
        int ix = name.lastIndexOf(".");
        AbstractSimon parent = this.rootSimon;
        if (ix != -1 && (parent = this.allSimons.get(parentName = name.substring(0, ix))) == null) {
            parent = new UnknownSimon(parentName, this);
            this.addToHierarchy(parent, parentName);
            this.allSimons.put(parentName, parent);
        }
        parent.addChild(simon);
    }

    @Override
    public CompositeCallback callback() {
        return this.callback;
    }

    @Override
    public ManagerConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public void enable() {
        throw new UnsupportedOperationException("Only SwitchingManager supports this operation.");
    }

    @Override
    public void disable() {
        throw new UnsupportedOperationException("Only SwitchingManager supports this operation.");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void message(String message) {
        this.callback.onManagerMessage(message);
    }

    @Override
    public void warning(String warning, Exception cause) {
        this.callback.onManagerWarning(warning, cause);
    }

    @Override
    public long nanoTime() {
        return this.clock.nanoTime();
    }

    @Override
    public long milliTime() {
        return this.clock.milliTime();
    }

    @Override
    public long millisForNano(long nanos) {
        return this.clock.millisForNano(nanos);
    }

    synchronized void purgeIncrementalSimonsOlderThan(long thresholdMs) {
        for (Simon simon : this.allSimons.values()) {
            if (!(simon instanceof AbstractSimon)) continue;
            AbstractSimon abstractSimon = (AbstractSimon)simon;
            abstractSimon.purgeIncrementalSimonsOlderThan(thresholdMs);
        }
    }
}

