/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;

public class Mp4TrackField
extends Mp4TagTextNumberField {
    private static final int NONE_VALUE_INDEX = 0;
    private static final int TRACK_NO_INDEX = 1;
    private static final int TRACK_TOTAL_INDEX = 2;
    private static final int NONE_END_VALUE_INDEX = 3;

    public Mp4TrackField(String trackValue) throws FieldDataInvalidException {
        super(Mp4FieldKey.TRACK.getFieldName(), trackValue);
        this.numbers = new ArrayList();
        this.numbers.add(new Short("0"));
        String[] values = trackValue.split("/");
        switch (values.length) {
            case 1: {
                try {
                    this.numbers.add(Short.parseShort(values[0]));
                }
                catch (NumberFormatException nfe) {
                    throw new FieldDataInvalidException("Value of:" + values[0] + " is invalid for field:" + this.id);
                }
                this.numbers.add(new Short("0"));
                this.numbers.add(new Short("0"));
                break;
            }
            case 2: {
                try {
                    this.numbers.add(Short.parseShort(values[0]));
                }
                catch (NumberFormatException nfe) {
                    throw new FieldDataInvalidException("Value of:" + values[0] + " is invalid for field:" + this.id);
                }
                try {
                    this.numbers.add(Short.parseShort(values[1]));
                }
                catch (NumberFormatException nfe) {
                    throw new FieldDataInvalidException("Value of:" + values[1] + " is invalid for field:" + this.id);
                }
                this.numbers.add(new Short("0"));
                break;
            }
            default: {
                throw new FieldDataInvalidException("Value is invalid for field:" + this.id);
            }
        }
    }

    public Mp4TrackField(int trackNo) {
        super(Mp4FieldKey.TRACK.getFieldName(), String.valueOf(trackNo));
        this.numbers = new ArrayList();
        this.numbers.add(new Short("0"));
        this.numbers.add((short)trackNo);
        this.numbers.add(new Short("0"));
        this.numbers.add(new Short("0"));
    }

    public Mp4TrackField(int trackNo, int total) {
        super(Mp4FieldKey.TRACK.getFieldName(), String.valueOf(trackNo));
        this.numbers = new ArrayList();
        this.numbers.add(new Short("0"));
        this.numbers.add((short)trackNo);
        this.numbers.add((short)total);
        this.numbers.add(new Short("0"));
    }

    public Mp4TrackField(String id, ByteBuffer data) throws UnsupportedEncodingException {
        super(id, data);
    }

    protected void build(ByteBuffer data) throws UnsupportedEncodingException {
        Mp4BoxHeader header = new Mp4BoxHeader(data);
        Mp4DataBox databox = new Mp4DataBox(header, data);
        this.dataSize = header.getDataLength();
        this.numbers = databox.getNumbers();
        StringBuffer sb = new StringBuffer();
        if (this.numbers != null) {
            if (this.numbers.size() > 1 && (Short)this.numbers.get(1) > 0) {
                sb.append(this.numbers.get(1));
            }
            if (this.numbers.size() > 2 && (Short)this.numbers.get(2) > 0) {
                sb.append("/").append(this.numbers.get(2));
            }
        }
        this.content = sb.toString();
    }

    public Short getTrackNo() {
        return (Short)this.numbers.get(1);
    }

    public Short getTrackTotal() {
        if (this.numbers.size() <= 2) {
            return (short)0;
        }
        return (Short)this.numbers.get(2);
    }

    public void setTrackNo(int trackNo) {
        this.numbers.set(1, (short)trackNo);
    }

    public void setTrackTotal(int trackTotal) {
        this.numbers.set(2, (short)trackTotal);
    }
}

