/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import ezvcard.Messages;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VCardDateFormat {
    DATE_BASIC("yyyyMMdd"),
    DATE_EXTENDED("yyyy-MM-dd"),
    DATE_TIME_BASIC("yyyyMMdd'T'HHmmssZ"),
    DATE_TIME_EXTENDED("yyyy-MM-dd'T'HH:mm:ssZ"){

        public DateFormat getDateFormat(TimeZone timezone) {
            SimpleDateFormat df = new SimpleDateFormat(this.formatStr){

                public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                    StringBuffer sb = super.format(date, toAppendTo, fieldPosition);
                    sb.insert(sb.length() - 2, ':');
                    return sb;
                }
            };
            if (timezone != null) {
                df.setTimeZone(timezone);
            }
            return df;
        }
    }
    ,
    UTC_DATE_TIME_BASIC("yyyyMMdd'T'HHmmss'Z'"){

        public DateFormat getDateFormat(TimeZone timezone) {
            TimeZone utc = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(utc);
        }
    }
    ,
    UTC_DATE_TIME_EXTENDED("yyyy-MM-dd'T'HH:mm:ss'Z'"){

        public DateFormat getDateFormat(TimeZone timezone) {
            TimeZone utc = TimeZone.getTimeZone("UTC");
            return super.getDateFormat(utc);
        }
    }
    ,
    HCARD_DATE_TIME("yyyy-MM-dd'T'HH:mm:ssZ");

    protected final String formatStr;

    private VCardDateFormat(String formatStr) {
        this.formatStr = formatStr;
    }

    public DateFormat getDateFormat() {
        return this.getDateFormat(null);
    }

    public DateFormat getDateFormat(TimeZone timezone) {
        SimpleDateFormat df = new SimpleDateFormat(this.formatStr);
        if (timezone != null) {
            df.setTimeZone(timezone);
        }
        return df;
    }

    public String format(Date date) {
        return this.format(date, null);
    }

    public String format(Date date, TimeZone timezone) {
        DateFormat df = this.getDateFormat(timezone);
        return df.format(date);
    }

    public static Date parse(String dateStr) {
        TimestampPattern p = new TimestampPattern(dateStr);
        if (!p.matches()) {
            throw Messages.INSTANCE.getIllegalArgumentException(41, dateStr);
        }
        TimeZone timezone = p.hasOffset() ? TimeZone.getTimeZone("UTC") : TimeZone.getDefault();
        Calendar c = Calendar.getInstance(timezone);
        c.clear();
        c.set(1, p.year());
        c.set(2, p.month() - 1);
        c.set(5, p.date());
        if (p.hasTime()) {
            c.set(11, p.hour());
            c.set(12, p.minute());
            c.set(13, p.second());
            c.set(14, p.millisecond());
            if (p.hasOffset()) {
                c.set(15, p.offsetMillis());
            }
        }
        return c.getTime();
    }

    public static boolean dateHasTime(String dateStr) {
        return dateStr.contains("T");
    }

    public static boolean dateHasTimezone(String dateStr) {
        return dateStr.endsWith("Z") || dateStr.matches(".*?[-+]\\d\\d:?\\d\\d");
    }

    public static TimeZone parseTimeZoneId(String timezoneId) {
        TimeZone timezone = TimeZone.getTimeZone(timezoneId);
        return "GMT".equals(timezone.getID()) ? null : timezone;
    }

    private static class TimestampPattern {
        private static final Pattern regex = Pattern.compile("^(\\d{4})(-?(\\d{2})-?(\\d{2})|-(\\d{1,2})-(\\d{1,2}))(T(\\d{2}):?(\\d{2}):?(\\d{2})(\\.\\d+)?(Z|([-+])((\\d{2})|((\\d{2}):?(\\d{2}))))?)?$");
        private final Matcher m;
        private final boolean matches;

        public TimestampPattern(String str) {
            this.m = regex.matcher(str);
            this.matches = this.m.find();
        }

        public boolean matches() {
            return this.matches;
        }

        public int year() {
            return this.parseInt(1);
        }

        public int month() {
            return this.parseInt(3, 5);
        }

        public int date() {
            return this.parseInt(4, 6);
        }

        public boolean hasTime() {
            return this.m.group(8) != null;
        }

        public int hour() {
            return this.parseInt(8);
        }

        public int minute() {
            return this.parseInt(9);
        }

        public int second() {
            return this.parseInt(10);
        }

        public int millisecond() {
            String s = this.m.group(11);
            if (s == null) {
                return 0;
            }
            double ms = Double.parseDouble(s) * 1000.0;
            return (int)Math.round(ms);
        }

        public boolean hasOffset() {
            return this.m.group(12) != null;
        }

        public int offsetMillis() {
            int offsetMinute;
            int offsetHour;
            int positive;
            if (this.m.group(12).equals("Z")) {
                return 0;
            }
            int n = positive = this.m.group(13).equals("+") ? 1 : -1;
            if (this.m.group(15) != null) {
                offsetHour = this.parseInt(15);
                offsetMinute = 0;
            } else {
                offsetHour = this.parseInt(17);
                offsetMinute = this.parseInt(18);
            }
            return (offsetHour * 60 * 60 * 1000 + offsetMinute * 60 * 1000) * positive;
        }

        private int parseInt(int ... group) {
            for (int g : group) {
                String s = this.m.group(g);
                if (s == null) continue;
                return Integer.parseInt(s);
            }
            throw new NullPointerException();
        }
    }
}

