/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.SupportedVersions;
import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.ValidationWarning;
import ezvcard.parameter.ImppType;
import ezvcard.parameter.Pid;
import ezvcard.parameter.VCardParameters;
import ezvcard.property.HasAltId;
import ezvcard.property.VCardProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedVersions(value={VCardVersion.V3_0, VCardVersion.V4_0})
public class Impp
extends VCardProperty
implements HasAltId {
    private static final String AIM = "aim";
    private static final String ICQ = "icq";
    private static final String IRC = "irc";
    private static final String MSN = "msnim";
    private static final String SIP = "sip";
    private static final String SKYPE = "skype";
    private static final String XMPP = "xmpp";
    private static final String YAHOO = "ymsgr";
    private URI uri;

    public Impp(String uri) {
        this.setUri(uri);
    }

    public Impp(URI uri) {
        this.setUri(uri);
    }

    public Impp(String protocol, String handle) {
        this.setUri(protocol, handle);
    }

    public Impp(Impp original) {
        super(original);
        this.uri = original.uri;
    }

    public static Impp aim(String handle) {
        return new Impp(AIM, handle);
    }

    public boolean isAim() {
        return this.isProtocol(AIM);
    }

    public static Impp yahoo(String handle) {
        return new Impp(YAHOO, handle);
    }

    public boolean isYahoo() {
        return this.isProtocol(YAHOO);
    }

    public static Impp msn(String handle) {
        return new Impp(MSN, handle);
    }

    public boolean isMsn() {
        return this.isProtocol(MSN);
    }

    public static Impp icq(String handle) {
        return new Impp(ICQ, handle);
    }

    public boolean isIcq() {
        return this.isProtocol(ICQ);
    }

    public static Impp irc(String handle) {
        return new Impp(IRC, handle);
    }

    public boolean isIrc() {
        return this.isProtocol(IRC);
    }

    public static Impp sip(String handle) {
        return new Impp(SIP, handle);
    }

    public boolean isSip() {
        return this.isProtocol(SIP);
    }

    public static Impp skype(String handle) {
        return new Impp(SKYPE, handle);
    }

    public boolean isSkype() {
        return this.isProtocol(SKYPE);
    }

    public static Impp xmpp(String handle) {
        return new Impp(XMPP, handle);
    }

    public boolean isXmpp() {
        return this.isProtocol(XMPP);
    }

    private boolean isProtocol(String protocol) {
        return this.uri != null && protocol.equals(this.uri.getScheme());
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.setUri(uri == null ? null : URI.create(uri));
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUri(String protocol, String handle) {
        try {
            this.uri = new URI(protocol, handle, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getProtocol() {
        if (this.uri == null) {
            return null;
        }
        return this.uri.getScheme();
    }

    public String getHandle() {
        if (this.uri == null) {
            return null;
        }
        return this.uri.getSchemeSpecificPart();
    }

    public List<ImppType> getTypes() {
        return new VCardParameters.TypeParameterList<ImppType>(this.parameters){

            @Override
            protected ImppType _asObject(String value) {
                return ImppType.get(value);
            }
        };
    }

    public String getMediaType() {
        return this.parameters.getMediaType();
    }

    public void setMediaType(String mediaType) {
        this.parameters.setMediaType(mediaType);
    }

    @Override
    public List<Pid> getPids() {
        return super.getPids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<ValidationWarning> warnings, VCardVersion version, VCard vcard) {
        if (this.uri == null) {
            warnings.add(new ValidationWarning(8, new Object[0]));
        }
    }

    @Override
    protected Map<String, Object> toStringValues() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("uri", this.uri);
        return values;
    }

    @Override
    public Impp copy() {
        return new Impp(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Impp other = (Impp)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

