/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.util.ComparableByContent;
import java.util.function.Function;

public class VerboseResult<T>
implements ComparableByContent<VerboseResult<?>> {
    private final long operationTimeNanos;
    private final T value;
    private final BucketConfiguration configuration;
    private final BucketState state;

    public VerboseResult(long operationTimeNanos, T value, BucketConfiguration configuration, BucketState state) {
        this.operationTimeNanos = operationTimeNanos;
        this.value = value;
        this.configuration = configuration;
        this.state = state;
    }

    public T getValue() {
        return this.value;
    }

    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    public BucketState getState() {
        return this.state;
    }

    public long getOperationTimeNanos() {
        return this.operationTimeNanos;
    }

    public Diagnostics getDiagnostics() {
        return new Diagnostics(){

            @Override
            public long calculateFullRefillingTime() {
                return VerboseResult.this.state.calculateFullRefillingTime(VerboseResult.this.configuration.getBandwidths(), VerboseResult.this.operationTimeNanos);
            }

            @Override
            public long getAvailableTokens() {
                return VerboseResult.this.state.getAvailableTokens(VerboseResult.this.configuration.getBandwidths());
            }

            @Override
            public long[] getAvailableTokensPerEachBandwidth() {
                Bandwidth[] bandwidths = VerboseResult.this.configuration.getBandwidths();
                long[] availableTokens = new long[bandwidths.length];
                for (int i = 0; i < bandwidths.length; ++i) {
                    availableTokens[i] = VerboseResult.this.state.getCurrentSize(i);
                }
                return availableTokens;
            }
        };
    }

    public <R> VerboseResult<R> map(Function<T, R> mapper) {
        return new VerboseResult<R>(this.operationTimeNanos, mapper.apply(this.value), this.configuration, this.state);
    }

    @Override
    public boolean equalsByContent(VerboseResult<?> other) {
        return this.operationTimeNanos == other.operationTimeNanos && ComparableByContent.equals(this.value, other.value) && this.configuration.equalsByContent(other.configuration) && ComparableByContent.equals(this.state, other.state);
    }

    public static interface Diagnostics {
        public long calculateFullRefillingTime();

        public long getAvailableTokens();

        public long[] getAvailableTokensPerEachBandwidth();
    }
}

