/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState64BitsInteger;
import io.github.bucket4j.BucketStateIEEE754;
import io.github.bucket4j.MathType;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.IOException;

public interface BucketState {
    public BucketState copy();

    public BucketState replaceConfiguration(BucketConfiguration var1, BucketConfiguration var2, TokensInheritanceStrategy var3, long var4);

    public void copyStateFrom(BucketState var1);

    public long getAvailableTokens(Bandwidth[] var1);

    public void consume(Bandwidth[] var1, long var2);

    public long calculateDelayNanosAfterWillBePossibleToConsume(Bandwidth[] var1, long var2, long var4);

    public long calculateFullRefillingTime(Bandwidth[] var1, long var2);

    public void refillAllBandwidth(Bandwidth[] var1, long var2);

    public void addTokens(Bandwidth[] var1, long var2);

    public void forceAddTokens(Bandwidth[] var1, long var2);

    public long getCurrentSize(int var1);

    public long getRoundingError(int var1);

    public MathType getMathType();

    public static BucketState createInitialState(BucketConfiguration configuration, MathType mathType, long currentTimeNanos) {
        switch (mathType) {
            case INTEGER_64_BITS: {
                return new BucketState64BitsInteger(configuration, currentTimeNanos);
            }
            case IEEE_754: {
                return new BucketStateIEEE754(configuration, currentTimeNanos);
            }
        }
        throw new IllegalStateException("Unsupported mathType:" + (Object)((Object)mathType));
    }

    public static <S> BucketState deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
        int typeId = adapter.readInt(input);
        if (typeId == BucketState64BitsInteger.SERIALIZATION_HANDLE.getTypeId()) {
            return BucketState64BitsInteger.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
        }
        if (typeId == BucketStateIEEE754.SERIALIZATION_HANDLE.getTypeId()) {
            return BucketStateIEEE754.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
        }
        throw new IOException("Unknown typeId=" + typeId);
    }

    public static <O> void serialize(SerializationAdapter<O> adapter, O output, BucketState state, Version backwardCompatibilityVersion) throws IOException {
        switch (state.getMathType()) {
            case INTEGER_64_BITS: {
                adapter.writeInt(output, BucketState64BitsInteger.SERIALIZATION_HANDLE.getTypeId());
                BucketState64BitsInteger.SERIALIZATION_HANDLE.serialize(adapter, output, (BucketState64BitsInteger)state, backwardCompatibilityVersion);
                break;
            }
            case IEEE_754: {
                adapter.writeInt(output, BucketStateIEEE754.SERIALIZATION_HANDLE.getTypeId());
                BucketStateIEEE754.SERIALIZATION_HANDLE.serialize(adapter, output, (BucketStateIEEE754)state, backwardCompatibilityVersion);
                break;
            }
            default: {
                throw new IOException("Unknown mathType=" + (Object)((Object)state.getMathType()));
            }
        }
    }
}

