/*
 * Decompiled with CFR 0.152.
 */
package io.socket.engineio.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class EngineIoSocketTimeoutHandler {
    private final ExecutorService executorPool;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new EngineIoThreadFactory("scheduler"));

    EngineIoSocketTimeoutHandler(int maxThreadPoolSize) {
        this.executorPool = new ThreadPoolExecutor(1, maxThreadPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), new EngineIoThreadFactory("pool"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    ScheduledFuture schedule(Runnable socketTimeoutTask, long timeout, TimeUnit timeUnit) {
        Runnable executorTask = () -> this.executorPool.execute(socketTimeoutTask);
        return this.scheduledExecutorService.schedule(executorTask, timeout, timeUnit);
    }

    private static class EngineIoThreadFactory
    implements ThreadFactory {
        private AtomicInteger count = new AtomicInteger();
        private String mGroupNamePostfix;

        EngineIoThreadFactory(String groupNamePostfix) {
            this.mGroupNamePostfix = groupNamePostfix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName(String.format("engineIo-socketTimeout-%s-%d", this.mGroupNamePostfix, this.count.incrementAndGet()));
            thread.setDaemon(true);
            return thread;
        }
    }
}

