/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsClientHandler;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.ErrorResponse;
import com.eatthepath.pushy.apns.auth.AuthenticationToken;
import com.eatthepath.pushy.apns.auth.AuthenticationTokenProvider;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AsciiString;
import io.netty.util.collection.IntObjectHashMap;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthenticationApnsClientHandler
extends ApnsClientHandler {
    private final AuthenticationTokenProvider authenticationTokenProvider;
    private final Http2Connection.PropertyKey authenticationTokenPropertyKey;
    private final Map<Integer, AuthenticationToken> unattachedAuthenticationTokensByStreamId = new IntObjectHashMap();
    private static final AsciiString APNS_AUTHORIZATION_HEADER = new AsciiString((CharSequence)"authorization");
    private static final String EXPIRED_AUTH_TOKEN_REASON = "ExpiredProviderToken";
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationApnsClientHandler.class);

    protected TokenAuthenticationApnsClientHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, String authority, Duration idlePingInterval, AuthenticationTokenProvider authenticationTokenProvider) {
        super(decoder, encoder, initialSettings, authority, idlePingInterval);
        this.authenticationTokenProvider = Objects.requireNonNull(authenticationTokenProvider, "Authentication token provider must not be null for token-based client handlers.");
        this.authenticationTokenPropertyKey = this.connection().newKey();
    }

    @Override
    public void onStreamAdded(Http2Stream stream) {
        super.onStreamAdded(stream);
        stream.setProperty(this.authenticationTokenPropertyKey, (Object)this.unattachedAuthenticationTokensByStreamId.remove(stream.id()));
    }

    @Override
    public void onStreamRemoved(Http2Stream stream) {
        super.onStreamRemoved(stream);
        stream.removeProperty(this.authenticationTokenPropertyKey);
    }

    @Override
    protected Http2Headers getHeadersForPushNotification(ApnsPushNotification pushNotification, ChannelHandlerContext context, int streamId) {
        AuthenticationToken authenticationToken = this.authenticationTokenProvider.getAuthenticationToken();
        this.unattachedAuthenticationTokensByStreamId.put(streamId, authenticationToken);
        return (Http2Headers)super.getHeadersForPushNotification(pushNotification, context, streamId).add((Object)APNS_AUTHORIZATION_HEADER, (Object)authenticationToken.getAuthorizationHeader());
    }

    @Override
    protected void handleErrorResponse(ChannelHandlerContext context, int streamId, Http2Headers headers, ApnsPushNotification pushNotification, ErrorResponse errorResponse) {
        super.handleErrorResponse(context, streamId, headers, pushNotification, errorResponse);
        if (EXPIRED_AUTH_TOKEN_REASON.equals(errorResponse.getReason())) {
            log.warn("APNs server reports token for channel {} has expired.", (Object)context.channel());
            this.authenticationTokenProvider.expireAuthenticationToken((AuthenticationToken)this.connection().stream(streamId).getProperty(this.authenticationTokenPropertyKey));
            context.close();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext context) throws Exception {
        this.unattachedAuthenticationTokensByStreamId.clear();
        super.channelInactive(context);
    }

    public static class TokenAuthenticationApnsClientHandlerBuilder
    extends ApnsClientHandler.ApnsClientHandlerBuilder {
        private AuthenticationTokenProvider authenticationTokenProvider;

        public TokenAuthenticationApnsClientHandlerBuilder authenticationTokenProvider(AuthenticationTokenProvider authenticationTokenProvider) {
            this.authenticationTokenProvider = authenticationTokenProvider;
            return this;
        }

        public AuthenticationTokenProvider authenticationTokenProvider() {
            return this.authenticationTokenProvider;
        }

        @Override
        public ApnsClientHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            Objects.requireNonNull(this.authority(), "Authority must be set before building a TokenAuthenticationApnsClientHandler.");
            Objects.requireNonNull(this.authenticationTokenProvider(), "Authentication token provider must be set before building a TokenAuthenticationApnsClientHandler.");
            TokenAuthenticationApnsClientHandler handler = new TokenAuthenticationApnsClientHandler(decoder, encoder, initialSettings, this.authority(), this.idlePingInterval(), this.authenticationTokenProvider());
            this.frameListener(handler);
            return handler;
        }
    }
}

