/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Objects;

class P12Util {
    P12Util() {
    }

    public static KeyStore.PrivateKeyEntry getFirstPrivateKeyEntryFromP12InputStream(InputStream p12InputStream, String password) throws KeyStoreException, IOException {
        Objects.requireNonNull(password, "Password may be blank, but must not be null.");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        try {
            keyStore.load(p12InputStream, password.toCharArray());
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException(e);
        }
        Enumeration<String> aliases = keyStore.aliases();
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(password.toCharArray());
        while (aliases.hasMoreElements()) {
            KeyStore.Entry entry;
            String alias = aliases.nextElement();
            try {
                try {
                    entry = keyStore.getEntry(alias, passwordProtection);
                }
                catch (UnsupportedOperationException e) {
                    entry = keyStore.getEntry(alias, null);
                }
            }
            catch (NoSuchAlgorithmException | UnrecoverableEntryException e) {
                throw new KeyStoreException(e);
            }
            if (!(entry instanceof KeyStore.PrivateKeyEntry)) continue;
            return (KeyStore.PrivateKeyEntry)entry;
        }
        throw new KeyStoreException("Key store did not contain any private key entries.");
    }
}

