/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.json;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public class JsonSerializer {
    JsonSerializer() throws InstantiationException {
        throw new InstantiationException("JsonSerializer must not be instantiated directly.");
    }

    public static void writeJsonText(Map<?, ?> map, Appendable out) throws IOException {
        if (map == null) {
            out.append("null");
        } else if (map.isEmpty()) {
            out.append("{}");
        } else {
            out.append('{');
            boolean valuesWritten = false;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new NullPointerException("JSON object keys must not be null.");
                }
                if (valuesWritten) {
                    out.append(',');
                }
                JsonSerializer.writeJsonValue(entry.getKey().toString(), out);
                out.append(':');
                JsonSerializer.writeJsonValue(entry.getValue(), out);
                valuesWritten = true;
            }
            out.append('}');
        }
    }

    public static String writeJsonTextAsString(Map<?, ?> map) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(map, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(Collection<?> collection, Appendable out) throws IOException {
        if (collection == null) {
            out.append("null");
        } else if (collection.isEmpty()) {
            out.append("[]");
        } else {
            out.append('[');
            boolean valuesWritten = false;
            for (Object o : collection) {
                if (valuesWritten) {
                    out.append(',');
                }
                JsonSerializer.writeJsonValue(o, out);
                valuesWritten = true;
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(Collection<?> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(collection, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(byte[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            out.append(String.valueOf(array[0]));
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                out.append(String.valueOf(array[i]));
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(byte[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(short[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            out.append(String.valueOf(array[0]));
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                out.append(String.valueOf(array[i]));
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(short[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(int[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            out.append(String.valueOf(array[0]));
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                out.append(String.valueOf(array[i]));
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(int[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(long[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            out.append(String.valueOf(array[0]));
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                out.append(String.valueOf(array[i]));
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(long[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(float[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            out.append(String.valueOf(array[0]));
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                out.append(String.valueOf(array[i]));
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(float[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(double[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            out.append(String.valueOf(array[0]));
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                out.append(String.valueOf(array[i]));
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(double[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(boolean[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            out.append(String.valueOf(array[0]));
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                out.append(String.valueOf(array[i]));
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(boolean[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(char[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            JsonSerializer.writeJsonValue(array[0], out);
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                JsonSerializer.writeJsonValue(array[i], out);
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(char[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeJsonText(Object[] array, Appendable out) throws IOException {
        if (array == null) {
            out.append("null");
        } else if (array.length == 0) {
            out.append("[]");
        } else {
            out.append('[');
            JsonSerializer.writeJsonValue(array[0], out);
            for (int i = 1; i < array.length; ++i) {
                out.append(',');
                JsonSerializer.writeJsonValue(array[i], out);
            }
            out.append(']');
        }
    }

    public static String writeJsonTextAsString(Object[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JsonSerializer.writeJsonText(array, (Appendable)stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeJsonValue(Object o, Appendable out) throws IOException {
        if (o == null) {
            out.append("null");
        } else if (o instanceof Optional) {
            Optional optional = (Optional)o;
            if (optional.isPresent()) {
                JsonSerializer.writeJsonValue(optional.get(), out);
            } else {
                JsonSerializer.writeJsonValue(null, out);
            }
        } else if (o instanceof Map) {
            JsonSerializer.writeJsonText((Map)o, out);
        } else if (o instanceof Collection) {
            JsonSerializer.writeJsonText((Collection)o, out);
        } else if (o instanceof byte[]) {
            JsonSerializer.writeJsonText((byte[])o, out);
        } else if (o instanceof short[]) {
            JsonSerializer.writeJsonText((short[])o, out);
        } else if (o instanceof int[]) {
            JsonSerializer.writeJsonText((int[])o, out);
        } else if (o instanceof long[]) {
            JsonSerializer.writeJsonText((long[])o, out);
        } else if (o instanceof float[]) {
            JsonSerializer.writeJsonText((float[])o, out);
        } else if (o instanceof double[]) {
            JsonSerializer.writeJsonText((double[])o, out);
        } else if (o instanceof boolean[]) {
            JsonSerializer.writeJsonText((boolean[])o, out);
        } else if (o instanceof char[]) {
            JsonSerializer.writeJsonText((char[])o, out);
        } else if (o instanceof Object[]) {
            JsonSerializer.writeJsonText((Object[])o, out);
        } else if (o instanceof Number) {
            JsonSerializer.writeJsonValue((Number)o, out);
        } else if (o instanceof Boolean) {
            JsonSerializer.writeJsonValue((Boolean)o, out);
        } else {
            JsonSerializer.writeJsonValue(o.toString(), out);
        }
    }

    static void writeJsonValue(String string, Appendable out) throws IOException {
        if (string == null) {
            out.append("null");
        } else if ("".equals(string)) {
            out.append("\"\"");
        } else {
            out.append('\"');
            int start = 0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c != '\"' && c != '\\' && c != '/' && c != '\b' && c != '\f' && c != '\n' && c != '\r' && c != '\t' && !Character.isISOControl(c)) continue;
                out.append(string, start, i);
                JsonSerializer.appendEscapedCharacter(c, out);
                start = i + 1;
            }
            if (start == 0) {
                out.append(string);
            } else if (start < string.length()) {
                out.append(string, start, string.length());
            }
            out.append('\"');
        }
    }

    static void writeJsonValue(char c, Appendable out) throws IOException {
        out.append('\"');
        JsonSerializer.appendEscapedCharacter(c, out);
        out.append('\"');
    }

    private static void appendEscapedCharacter(char c, Appendable out) throws IOException {
        switch (c) {
            case '\"': {
                out.append("\\\"");
                break;
            }
            case '\\': {
                out.append("\\\\");
                break;
            }
            case '/': {
                out.append("\\/");
                break;
            }
            case '\b': {
                out.append("\\b");
                break;
            }
            case '\f': {
                out.append("\\f");
                break;
            }
            case '\n': {
                out.append("\\n");
                break;
            }
            case '\r': {
                out.append("\\r");
                break;
            }
            case '\t': {
                out.append("\\t");
                break;
            }
            default: {
                if (Character.isISOControl(c)) {
                    out.append("\\u");
                    out.append(Integer.toHexString(0x10000 | c), 1, 5);
                    break;
                }
                out.append(c);
            }
        }
    }

    static void writeJsonValue(Number number, Appendable out) throws IOException {
        if (number == null) {
            out.append("null");
        } else if (number instanceof Float) {
            JsonSerializer.writeJsonValue(number.floatValue(), out);
        } else if (number instanceof Double) {
            JsonSerializer.writeJsonValue(number.doubleValue(), out);
        } else {
            out.append(number.toString());
        }
    }

    static void writeJsonValue(byte b, Appendable out) throws IOException {
        out.append(Byte.toString(b));
    }

    static void writeJsonValue(short s, Appendable out) throws IOException {
        out.append(Short.toString(s));
    }

    static void writeJsonValue(int i, Appendable out) throws IOException {
        out.append(Integer.toString(i));
    }

    static void writeJsonValue(long l, Appendable out) throws IOException {
        out.append(Long.toString(l));
    }

    static void writeJsonValue(float f, Appendable out) throws IOException {
        if (Float.isInfinite(f)) {
            throw new IllegalArgumentException("Cannot write non-finite numbers as JSON values.");
        }
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException("Cannot write NaN as a JSON value.");
        }
        out.append(Float.toString(f));
    }

    static void writeJsonValue(double d, Appendable out) throws IOException {
        if (Double.isInfinite(d)) {
            throw new IllegalArgumentException("Cannot write non-finite numbers as JSON values.");
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Cannot write NaN as a JSON value.");
        }
        out.append(Double.toString(d));
    }

    static void writeJsonValue(Boolean b, Appendable out) throws IOException {
        if (b == null) {
            out.append("null");
        } else {
            JsonSerializer.writeJsonValue((boolean)b, out);
        }
    }

    static void writeJsonValue(boolean b, Appendable out) throws IOException {
        out.append(b ? "true" : "false");
    }
}

