/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLServerSocketFactory;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_THREADSAFE)
final class SetEnabledProtocolsAndCipherSuitesSSLServerSocketFactory
extends SSLServerSocketFactory {
    @NotNull
    private final Set<String> cipherSuites;
    @NotNull
    private final Set<String> protocols;
    @NotNull
    private final SSLServerSocketFactory delegateFactory;

    SetEnabledProtocolsAndCipherSuitesSSLServerSocketFactory(@NotNull SSLServerSocketFactory delegateFactory, @NotNull String defaultProtocol, @NotNull Set<String> cipherSuites) {
        this.delegateFactory = delegateFactory;
        this.cipherSuites = cipherSuites;
        this.protocols = defaultProtocol.equalsIgnoreCase("TLSv1.2") ? new HashSet<String>(Arrays.asList("TLSv1.2", "TLSv1.1", "TLSv1")) : (defaultProtocol.equalsIgnoreCase("TLSv1.1") ? new HashSet<String>(Arrays.asList("TLSv1.1", "TLSv1")) : (defaultProtocol.equalsIgnoreCase("TLSv1") ? new HashSet<String>(Collections.singletonList("TLSv1")) : Collections.emptySet()));
    }

    SetEnabledProtocolsAndCipherSuitesSSLServerSocketFactory(@NotNull SSLServerSocketFactory delegateFactory, @NotNull Set<String> protocols, @NotNull Set<String> cipherSuites) {
        this.delegateFactory = delegateFactory;
        this.protocols = protocols;
        this.cipherSuites = cipherSuites;
    }

    @Override
    @NotNull
    public ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket();
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        SSLUtil.applyEnabledSSLCipherSuites(serverSocket, this.cipherSuites);
        return serverSocket;
    }

    @Override
    @NotNull
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(port);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        SSLUtil.applyEnabledSSLCipherSuites(serverSocket, this.cipherSuites);
        return serverSocket;
    }

    @Override
    @NotNull
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(port, backlog);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        SSLUtil.applyEnabledSSLCipherSuites(serverSocket, this.cipherSuites);
        return serverSocket;
    }

    @Override
    @NotNull
    public ServerSocket createServerSocket(int port, int backlog, @NotNull InetAddress ifAddress) throws IOException {
        ServerSocket serverSocket = this.delegateFactory.createServerSocket(port, backlog, ifAddress);
        SSLUtil.applyEnabledSSLProtocols(serverSocket, this.protocols);
        SSLUtil.applyEnabledSSLCipherSuites(serverSocket, this.cipherSuites);
        return serverSocket;
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        return this.delegateFactory.getDefaultCipherSuites();
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        return this.delegateFactory.getSupportedCipherSuites();
    }
}

