/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class LDAPSearchListener
implements SearchResultListener {
    private static final long serialVersionUID = -1334215024363357539L;
    @NotNull
    private final LDAPSearchOutputHandler outputHandler;
    @Nullable
    private final List<EntryTransformation> entryTransformations;

    LDAPSearchListener(@NotNull LDAPSearchOutputHandler outputHandler, @Nullable List<EntryTransformation> entryTransformations) {
        this.outputHandler = outputHandler;
        this.entryTransformations = entryTransformations;
    }

    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        SearchResultEntry sre;
        if (this.entryTransformations == null) {
            sre = searchEntry;
        } else {
            Entry e = searchEntry;
            for (EntryTransformation t : this.entryTransformations) {
                e = t.transformEntry(e);
                if (e != null) continue;
                return;
            }
            sre = new SearchResultEntry(searchEntry.getMessageID(), e, searchEntry.getControls());
        }
        this.outputHandler.formatSearchResultEntry(sre);
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
        this.outputHandler.formatSearchResultReference(searchReference);
    }
}

