/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskState;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.LinkedList;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TaskManager {
    private TaskManager() {
    }

    @NotNull
    private static String getTaskDN(@NotNull String taskID) {
        return "ds-task-id=" + taskID + ',' + "cn=Scheduled Tasks,cn=tasks";
    }

    @Nullable
    public static Task getTask(@NotNull String taskID, @NotNull LDAPConnection connection) throws LDAPException, TaskException {
        try {
            SearchResultEntry taskEntry = connection.getEntry(TaskManager.getTaskDN(taskID));
            if (taskEntry == null) {
                return null;
            }
            return Task.decodeTask(taskEntry);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            if (le.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return null;
            }
            throw le;
        }
    }

    @NotNull
    public static List<Task> getTasks(@NotNull LDAPConnection connection) throws LDAPException {
        Filter filter = Filter.createEqualityFilter("objectClass", "ds-task");
        SearchResult result = connection.search("cn=Scheduled Tasks,cn=tasks", SearchScope.SUB, filter, new String[0]);
        LinkedList<Task> tasks = new LinkedList<Task>();
        for (SearchResultEntry e : result.getSearchEntries()) {
            try {
                tasks.add(Task.decodeTask(e));
            }
            catch (TaskException te) {
                Debug.debugException(te);
            }
        }
        return tasks;
    }

    @NotNull
    public static Task scheduleTask(@NotNull Task task, @NotNull LDAPConnection connection) throws LDAPException, TaskException {
        Entry taskEntry = task.createTaskEntry();
        connection.add(task.createTaskEntry());
        SearchResultEntry newTaskEntry = connection.getEntry(taskEntry.getDN());
        if (newTaskEntry == null) {
            throw new LDAPException(ResultCode.NO_SUCH_OBJECT);
        }
        return Task.decodeTask(newTaskEntry);
    }

    public static void cancelTask(@NotNull String taskID, @NotNull LDAPConnection connection) throws LDAPException {
        Modification mod = new Modification(ModificationType.REPLACE, "ds-task-state", TaskState.CANCELED_BEFORE_STARTING.getName());
        connection.modify(TaskManager.getTaskDN(taskID), mod);
    }

    public static void deleteTask(@NotNull String taskID, @NotNull LDAPConnection connection) throws LDAPException {
        connection.delete(TaskManager.getTaskDN(taskID));
    }

    @NotNull
    public static Task waitForTask(@NotNull String taskID, @NotNull LDAPConnection connection, long pollFrequency, long maxWaitTime) throws LDAPException, TaskException {
        long stopWaitingTime = maxWaitTime > 0L ? System.currentTimeMillis() + maxWaitTime : Long.MAX_VALUE;
        while (true) {
            Task t;
            if ((t = TaskManager.getTask(taskID, connection)) == null) {
                throw new TaskException(TaskMessages.ERR_TASK_MANAGER_WAIT_NO_SUCH_TASK.get(taskID));
            }
            if (t.isCompleted()) {
                return t;
            }
            long timeRemaining = stopWaitingTime - System.currentTimeMillis();
            if (timeRemaining <= 0L) {
                return t;
            }
            try {
                Thread.sleep(Math.min(pollFrequency, timeRemaining));
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
                Thread.currentThread().interrupt();
                throw new TaskException(TaskMessages.ERR_TASK_MANAGER_WAIT_INTERRUPTED.get(taskID), ie);
            }
        }
    }
}

