/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.FileArgument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPModify
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = -2602159836108416722L;
    @Nullable
    private BooleanArgument continueOnError;
    @Nullable
    private BooleanArgument defaultAdd;
    @Nullable
    private ControlArgument bindControls;
    @Nullable
    private FileArgument ldifFile;

    public static void main(@NotNull String[] args) {
        ResultCode resultCode = LDAPModify.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        LDAPModify ldapModify = new LDAPModify(outStream, errStream);
        return ldapModify.runTool(args);
    }

    public LDAPModify(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldapmodify";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Perform add, delete, modify, and modify DN operations in an LDAP directory server.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "5.1.4";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        String description = "Treat LDIF records that do not contain a changetype as add records.";
        this.defaultAdd = new BooleanArgument(Character.valueOf('a'), "defaultAdd", description);
        this.defaultAdd.addLongIdentifier("default-add", true);
        parser.addArgument(this.defaultAdd);
        description = "Attempt to continue processing additional changes if an error occurs.";
        this.continueOnError = new BooleanArgument(Character.valueOf('c'), "continueOnError", description);
        this.continueOnError.addLongIdentifier("continue-on-error", true);
        parser.addArgument(this.continueOnError);
        description = "The path to the LDIF file containing the changes.  If this is not provided, then the changes will be read from standard input.";
        this.ldifFile = new FileArgument(Character.valueOf('f'), "ldifFile", false, 1, "{path}", description, true, false, true, false);
        this.ldifFile.addLongIdentifier("ldif-file", true);
        parser.addArgument(this.ldifFile);
        description = "Information about a control to include in the bind request.";
        this.bindControls = new ControlArgument(null, "bindControl", false, 0, null, description);
        this.bindControls.addLongIdentifier("bind-control", true);
        parser.addArgument(this.bindControls);
    }

    @Override
    @NotNull
    protected List<Control> getBindControls() {
        return this.bindControls.getValues();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        try {
            ldifReader = this.ldifFile.isPresent() ? new LDIFReader(this.ldifFile.getValue()) : new LDIFReader(System.in);
        }
        catch (IOException ioe) {
            this.err(new Object[]{"I/O error creating the LDIF reader:  ", ioe.getMessage()});
            return ResultCode.LOCAL_ERROR;
        }
        try {
            connection = this.getConnection();
            this.out(new Object[]{"Connected to ", connection.getConnectedAddress(), Character.valueOf(':'), connection.getConnectedPort()});
        }
        catch (LDAPException le) {
            this.err(new Object[]{"Error connecting to the directory server:  ", le.getMessage()});
            return le.getResultCode();
        }
        resultCode = ResultCode.SUCCESS;
        while (true) {
            try {
                changeRecord = ldifReader.readChangeRecord(this.defaultAdd.isPresent());
            }
            catch (LDIFException le) {
                this.err(new Object[]{"Malformed change record:  ", le.getMessage()});
                if (!le.mayContinueReading()) {
                    this.err(new Object[]{"Unable to continue processing the LDIF content."});
                    resultCode = ResultCode.DECODING_ERROR;
                    break;
                }
                if (this.continueOnError.isPresent()) continue;
                resultCode = ResultCode.DECODING_ERROR;
                break;
            }
            catch (IOException ioe) {
                this.err(new Object[]{"I/O error encountered while reading a change record:  ", ioe.getMessage()});
                resultCode = ResultCode.LOCAL_ERROR;
                break;
            }
            if (changeRecord == null) break;
            try {
                this.out(new Object[]{"Processing ", changeRecord.getChangeType().toString(), " operation for ", changeRecord.getDN()});
                changeRecord.processChange(connection);
                this.out(new Object[]{"Success"});
                this.out(new Object[0]);
                continue;
            }
            catch (LDAPException le) {
                this.err(new Object[]{"Error:  ", le.getMessage()});
                this.err(new Object[]{"Result Code:  ", le.getResultCode().intValue(), " (", le.getResultCode().getName(), Character.valueOf(')')});
                if (le.getMatchedDN() != null) {
                    this.err(new Object[]{"Matched DN:  ", le.getMatchedDN()});
                }
                if (le.getReferralURLs() != null) {
                    for (String url : le.getReferralURLs()) {
                        this.err(new Object[]{"Referral URL:  ", url});
                    }
                }
                this.err(new Object[0]);
                if (!this.continueOnError.isPresent()) ** break;
                continue;
                resultCode = le.getResultCode();
            }
            break;
        }
        connection.close();
        this.out(new Object[]{"Disconnected from the server"});
        return resultCode;
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--ldifFile", "changes.ldif"};
        String description = "Attempt to apply the add, delete, modify, and/or modify DN operations contained in the 'changes.ldif' file against the specified directory server.";
        examples.put(args, description);
        args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--continueOnError", "--defaultAdd"};
        description = "Establish a connection to the specified directory server and then wait for information about the add, delete, modify, and/or modify DN operations to perform to be provided via standard input.  If any invalid operations are requested, then the tool will display an error message but will continue running.  Any LDIF record provided which does not include a 'changeType' line will be treated as an add request.";
        examples.put(args, description);
        return examples;
    }
}

