/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Comparator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RDNNameValuePair
implements Comparable<RDNNameValuePair>,
Comparator<RDNNameValuePair>,
Serializable {
    private static final long serialVersionUID = -8780852504883527870L;
    @NotNull
    private final ASN1OctetString attributeValue;
    @Nullable
    private final Schema schema;
    @NotNull
    private final String attributeName;
    @Nullable
    private volatile String normalizedAttributeName;
    @Nullable
    private volatile String normalizedString;
    @Nullable
    private volatile String stringRepresentation;

    RDNNameValuePair(@NotNull String attributeName, @NotNull ASN1OctetString attributeValue, @Nullable Schema schema) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.schema = schema;
        this.normalizedAttributeName = null;
        this.normalizedString = null;
        this.stringRepresentation = null;
    }

    @NotNull
    public String getAttributeName() {
        return this.attributeName;
    }

    @NotNull
    public String getNormalizedAttributeName() {
        if (this.normalizedAttributeName == null) {
            AttributeTypeDefinition attributeType;
            if (this.schema != null && (attributeType = this.schema.getAttributeType(this.attributeName)) != null) {
                this.normalizedAttributeName = StaticUtils.toLowerCase(attributeType.getNameOrOID());
            }
            if (this.normalizedAttributeName == null) {
                this.normalizedAttributeName = StaticUtils.toLowerCase(this.attributeName);
            }
        }
        return this.normalizedAttributeName;
    }

    public boolean hasAttributeName(@NotNull String name) {
        if (this.attributeName.equalsIgnoreCase(name)) {
            return true;
        }
        if (this.schema != null) {
            AttributeTypeDefinition attributeType = this.schema.getAttributeType(this.attributeName);
            return attributeType != null && attributeType.hasNameOrOID(name);
        }
        return false;
    }

    @NotNull
    public String getAttributeValue() {
        return this.attributeValue.stringValue();
    }

    @NotNull
    public byte[] getAttributeValueBytes() {
        return this.attributeValue.getValue();
    }

    @NotNull
    public ASN1OctetString getRawAttributeValue() {
        return this.attributeValue;
    }

    public boolean hasAttributeValue(@NotNull String value) {
        try {
            MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(this.attributeName, this.schema);
            return matchingRule.valuesMatch(new ASN1OctetString(value), this.attributeValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    public boolean hasAttributeValue(@NotNull byte[] value) {
        try {
            MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(this.attributeName, this.schema);
            return matchingRule.valuesMatch(new ASN1OctetString(value), this.attributeValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    @Override
    public int compareTo(@NotNull RDNNameValuePair p) {
        String thatNormalizedName;
        String thisNormalizedName = this.getNormalizedAttributeName();
        int nameComparison = thisNormalizedName.compareTo(thatNormalizedName = p.getNormalizedAttributeName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        try {
            MatchingRule matchingRule = MatchingRule.selectOrderingMatchingRule(this.attributeName, this.schema);
            return matchingRule.compareValues(this.attributeValue, p.attributeValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            String thisNormalizedString = this.toNormalizedString();
            String thatNormalizedString = p.toNormalizedString();
            return thisNormalizedString.compareTo(thatNormalizedString);
        }
    }

    @Override
    public int compare(@NotNull RDNNameValuePair p1, @NotNull RDNNameValuePair p2) {
        return p1.compareTo(p2);
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDNNameValuePair)) {
            return false;
        }
        RDNNameValuePair p = (RDNNameValuePair)o;
        return this.toNormalizedString().equals(p.toNormalizedString());
    }

    @NotNull
    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer, false);
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }

    @NotNull
    public String toMinimallyEncodedString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer, boolean minimizeEncoding) {
        if (this.stringRepresentation != null && !minimizeEncoding) {
            buffer.append(this.stringRepresentation);
            return;
        }
        boolean bufferWasEmpty = buffer.length() == 0;
        buffer.append(this.attributeName);
        buffer.append('=');
        RDN.appendValue(buffer, this.attributeValue, minimizeEncoding);
        if (bufferWasEmpty && !minimizeEncoding) {
            this.stringRepresentation = buffer.toString();
        }
    }

    @NotNull
    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedString = buffer.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(@NotNull StringBuilder buffer) {
        buffer.append(this.getNormalizedAttributeName());
        buffer.append('=');
        RDN.appendNormalizedValue(buffer, this.attributeName, this.attributeValue, this.schema);
    }
}

