/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.networking.IOOutOfMemoryHandler;
import com.hazelcast.internal.networking.SocketChannelWrapper;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.logging.ILogger;
import java.io.EOFException;

public abstract class AbstractHandler {
    protected final SocketConnection connection;
    protected final ILogger logger;
    protected final SocketChannelWrapper socketChannel;
    private final IOOutOfMemoryHandler oomeHandler;

    public AbstractHandler(SocketConnection connection, ILogger logger, IOOutOfMemoryHandler oomeHandler) {
        this.connection = connection;
        this.oomeHandler = oomeHandler;
        this.logger = logger;
        this.socketChannel = connection.getSocketChannel();
    }

    public SocketChannelWrapper getSocketChannel() {
        return this.socketChannel;
    }

    public void onFailure(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            this.oomeHandler.handle((OutOfMemoryError)e);
        }
        if (e instanceof EOFException) {
            this.connection.close("Connection closed by the other side", e);
        } else {
            this.connection.close("Exception in " + this.getClass().getSimpleName(), e);
        }
    }
}

